/*
 * bulk_collect2.sql
 * Rozdzia 4., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt ilustruje operacje masowe.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

DECLARE
  TYPE title_record IS RECORD
  ( title VARCHAR2(60)
  , subtitle VARCHAR2(60));
  TYPE collection IS TABLE OF TITLE_RECORD;
  full_title COLLECTION;
  CURSOR c IS
    SELECT item_title
    ,      item_subtitle
    FROM   item;
BEGIN
  OPEN c;
  LOOP
    FETCH c BULK COLLECT INTO full_title LIMIT 10;
    EXIT WHEN full_title.COUNT = 0;
    FOR i IN 1..full_title.COUNT LOOP
      dbms_output.put_line('Tytu ['||full_title(i).title||']');
    END LOOP;
  END LOOP;
END;
/




















