/*
 * bulk_collect1.sql
 * Rozdzia 4., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt ilustruje operacje masowe.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

DECLARE
  -- Definicje typw skalarnych.
  TYPE title_collection IS TABLE OF VARCHAR2(60);
  TYPE subtitle_collection IS TABLE OF VARCHAR2(60);
  -- Definicje zmiennych lokalnych.
  title    TITLE_COLLECTION;
  subtitle SUBTITLE_COLLECTION;
  -- Definicja kursora statycznego.
  CURSOR c IS
    SELECT  item_title
    ,       item_subtitle
    FROM    item;
BEGIN
  OPEN c;
  LOOP
    FETCH c BULK COLLECT INTO title, subtitle LIMIT 10;
    EXIT WHEN title.COUNT = 0;
    FOR i IN 1..title.COUNT LOOP
      dbms_output.put_line('Tytu ['||title(i)||']');
    END LOOP;
  END LOOP;
END;
/



















