/*
 * assoc_table.sql
 * Rozdzia 3., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt ilustruje tworzenie tabel asocjacyjnych.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

DECLARE
  TYPE number_table IS TABLE OF NUMBER
    INDEX BY PLS_INTEGER;
  list NUMBER_TABLE;
BEGIN
  FOR i IN 1..6 LOOP
    list(i) := i;   -- Jawne przypisanie niezbdne w tablicach asocjacyjnych.
  END LOOP;
  list.DELETE(2);
  FOR i IN 1..list.COUNT LOOP
    IF list.EXISTS THEN 
      dbms_output.put('['||set(i)||']');
    END IF;
  END LOOP;
  dbms_output.new_line;
END;
/







