/*
 * query_profiler.sql
 * Dodatek G, Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt pobiera dane z hierarchicznego programu profilujcego jzyka PL/SQL.
 */

COL method_name           FORMAT A30
COL function_name         FORMAT A24
COL subtree_elapsed_time  FORMAT 99.90 HEADING "Czas w|drzewie|podrz."
COL function_elapsed_time FORMAT 99.90 HEADING "Czas w|funkcji"
COL calls                 FORMAT 99    HEADING "Wywoania"

SELECT   RPAD(' ',level*2,' ')||dfi.owner||'.'||dfi.module AS method_name
,        dfi.function AS function_name
,       (dpci.subtree_elapsed_time/1000) AS subtree_elapsed_time
,       (dpci.function_elapsed_time/1000) AS function_elapsed_time
,        dpci.calls
FROM     dbmshp_parent_child_info dpci
,        dbmshp_function_info dfi
WHERE    dpci.runid = dfi.runid
AND      dpci.parentsymid = dfi.symbolid
AND      dpci.runid = 4
CONNECT
BY PRIOR dpci.childsymid = dpci.parentsymid  -- Element potomny zawsze naley podawa po lewej stronie.
START
WITH     dpci.parentsymid = 1;
