-- regexp_replace.sql
-- Dodatek E, Oracle Database 11g. Programowanie w jzyku PL/SQL
-- Michael McLaughlin
--
-- Ten skrypt tworzy tabel i generuje dane potrzebne do demonstracji
-- dziaania funkcji do obsugi wyrae regularnych.

SET ECHO OFF
SET FEEDBACK ON
SET NULL '<Null>'
SET PAGESIZE 999
SET SERVEROUTPUT ON

DECLARE
  container VARCHAR2(4000);
  beginning NUMBER := 1;
  ending    NUMBER;
  -- Definicja kursora, ktry pozwala przywrci poprawny tekst.
  CURSOR c IS
    SELECT story_thread
    FROM   sample_regexp
    WHERE  REGEXP_LIKE(story_thread,'a last alliance of elves and men ?','i');
BEGIN
  OPEN c;
  LOOP
    FETCH c INTO container;
    EXIT WHEN c%NOTFOUND;
    -- Okrelenie koca przedziau.
    ending := REGEXP_COUNT(container
                          ,'((^| +)|(["'']))Sauron(([-:,\.;])|( +|$))',1,'i');
    -- Zastpienie po kolei wszystkich wystpie podacucha.
    FOR i IN beginning..ending LOOP
      container := REGEXP_REPLACE(container,'Sauron','Sauroman',beginning,i);
    END LOOP;
    dbms_output.put_line(container);
  END LOOP;
END;
/

