/*
 * get_directory_path.sql
 * Dodatek D, Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *  - Ten skrypt trzeba uruchomi z konta SYSTEM.
 *  - Uytkownik SYSTEM musi mie uprawnienia SELECT przyznane bezporednio, a nie przez rol.
 *  - Uytkownik SYSTEM domylnie ma dostp do katalogu przez rol SELECT_CATALOG_ROLE.
 *  - Naley przyzna uprawnienia uytkownikowi SYSTEM:
 *
 *     SQL> CONNECT / as sysdba
 *     Connected.
 *     SQL> GRANT SELECT ON dba_directories TO system;
 *     Grant succeeded.
 *
 * Ten skrypt tworzy funkcj skadowan, ktra zwraca ciek do
 * katalogu na podstawie okrelonego katalogu witrualnego bazy danych.
 */

-- Suy do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

CREATE OR REPLACE FUNCTION get_directory_path
( virtual_directory IN VARCHAR2 )
RETURN VARCHAR2 IS

  -- Definicja zwracanej zmiennej.
  directory_path VARCHAR2(256) := 'C:\';

  -- Definicja kursora dynamicznego.
  CURSOR get_directory (virtual_directory VARCHAR2) IS
    SELECT   directory_path
    FROM     sys.dba_directories
    WHERE    directory_name = virtual_directory;

  -- Definicja lokalnego wyjtku zwizanego z bdn nazw.
  directory_name EXCEPTION;
  PRAGMA EXCEPTION_INIT(directory_name,-22284);  

BEGIN

  OPEN  get_directory (virtual_directory);
  FETCH get_directory
  INTO  directory_path;
  CLOSE get_directory;

  -- Zwracanie nazwy pliku.
  RETURN directory_path;

EXCEPTION
  WHEN directory_name THEN
  RETURN NULL;

END get_directory_path;
/

show errors

GRANT EXECUTE ON get_directory_path TO php;

GRANT CREATE ANY SYNONYM TO php;

CONNECT php/php

CREATE SYNONYM get_directory_path FOR system.get_directory_path;
