// --------------------------------------------------------------------
// WriteReadCLOB.java
// Dodatek D, Oracle Database 11g. Programowanie w jzyku PL/SQL
// Michael McLaughlin
//
// Ten kod ilustruje wczytywanie pliku obrazu i wywietlanie
// go w obiekcie typu JLabel w ramce JFrame.
//
// Instrukcje UPDATE i SELECT zale od elementw generowanych przez
// skrypt create_store.sql, ktry mona pobra z witryny
// wydawnictwa.
// --------------------------------------------------------------------

// Importowanie klas na przykad aplikacji w jzyku Java.
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.io.Reader;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

// Importowanie oglnych klas do obsugi pocze JDBC.
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

// Importowanie klas do obsugi pocze JDBC z baz Oracle.
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.pool.OracleDataSource;

// Doczanie bibliotek opisanych w ksice (dostpnych w witrynie wydawnictwa).
import plsql.jdbc.DataConnectionPane;
import plsql.fileio.FileIO;
// -------------------------------------------------------------------/
public class WriteReadCLOB extends JFrame {
  // Definicja poczenia z baz danych.
  private String host;
  private String port;
  private String dbname;
  private String userid;
  private String passwd;

  // Definicja panelu na dane potrzebne w poczeniu.
  private DataConnectionPane message = new DataConnectionPane();

  // Tworzenie klasy.
  public WriteReadCLOB (String s) {
    super(s);

    // Pobranie danych potrzebnych do utworzenia poczenia lub zakoczenie dziaania programu.
    if (JOptionPane.showConfirmDialog(this,message
          ,"Podaj wartoci acucha znakw poczenia z Oracle"
          ,JOptionPane.OK_CANCEL_OPTION) == 0) {

      // Ustawienie zmiennych potrzebnych do nawizania poczenia.
      host = message.getHost();
      port = message.getPort();
      dbname = message.getDatabase();
      userid = message.getUserID();
      passwd = message.getPassword();

      // Wywietlenie informacji o poczeniu w oknie konsoli (narzdzie diagnostyczne).
      message.getConnection();

      // Utworzenie panelu JPanel sucego do wywietlania danych.
      ManageCLOB panel = new ManageCLOB();

      // Konfigurowanie panelu JPanel.
      panel.setOpaque(true);
      setContentPane(panel);

      // Konfigurowanie ramki JFrame.
      setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
      setLocation(100,100);
      pack();
      setVisible(true); }
    else
      System.exit(1); }
  // -------------------------------------------------------------------/
  private class ManageCLOB extends JPanel {
    // Definicje zmiennych potrzebnych przy wywietlaniu danych.
    private String clobText;
    private JScrollPane scrollPane;
    private JTextArea textArea;
    // -----------------------------------------------------------------/
    public ManageCLOB () {
      // Ustawienie menedera wywietlania.
      super(new GridLayout(1,0));

      // Powizanie odczytu pliku ze zmienn typu String.
      clobText = FileIO.openFile(FileIO.findFile(this));

      // Wstawienie rekordu i pniejsze pobranie go.
      if (clobText.length() > 0) {
        if (insertClob(host,port,dbname,userid,passwd,clobText))
          clobText = getQuery(host,port,dbname,userid,passwd); }
      else
        System.exit(2);

      // Tworzenie i formatowanie obszaru tekstowego.
      textArea = new JTextArea(clobText);
      textArea.setEditable(false);
      textArea.setFont(new Font(Font.SANS_SERIF,Font.PLAIN,14));
      textArea.setLineWrap(true);
      textArea.setRows(10);
      textArea.setSize(400,100);
      textArea.setWrapStyleWord(true);

      // Umieszczanie obrazu w kontenerze i dodawanie etykiety do panelu.
      scrollPane = new JScrollPane(textArea);
      add(scrollPane); }
    // ---------------------------------------------------------------/
    private Boolean insertClob(String host,String port,String dbname
                              ,String user,String pswd,String fileString) {
      try
      {
        // Ustawianie rdowej puli pocze.
        OracleDataSource ods = new OracleDataSource();
        String url = "jdbc:oracle:thin:@//"+host+":"+port+"/"+dbname;
        ods.setURL(url);
        ods.setUser(userid);
        ods.setPassword(passwd);

        // Definicja poczenia.
        Connection conn = ods.getConnection();

        // Tworzenie instrukcji.
        CallableStatement stmt =
          conn.prepareCall("UPDATE item "+
                           "SET    item_desc = ? "+
                           "WHERE  item_title = "+
                           "'The Lord of the Rings - Fellowship of the Ring'"+
                           "AND    item_subtitle = 'Widescreen Edition'");

        // Ustawienie acucha znakw w instrukcji.
        stmt.setString(1,fileString);

        // Wykonywanie zapytania.
        if (stmt.execute())
          conn.commit();

        // Zamykanie zasobw.
        stmt.close();
        conn.close();

        // Zwracanie danych typu CLOB jako acucha znakw.
        return true; } 
      catch (SQLException e) {
        if (e.getSQLState() == null) {
          System.out.println(
            new SQLException("Bd uproszczonego klienckiego poczenia Oracle Net8.",
                             "ORA-" + e.getErrorCode() +
                             ": Bdne argumenty uproszczonego klienta Net8:\n\n" +
                             "  nazwa serwera [" + host + "]\n" +
                             "  numer portu   [" + port + "]\n" +
                             "  nazwa bazy    [" + dbname + "]\n"
                             , e.getErrorCode()).getSQLState());

          // Zwrcenie pustego acucha znakw po wystpieniu bdu.
          return false; }
        else {
          System.out.println(e.getMessage());

          // Zwrcenie pustego acucha znakw po wystpieniu bdu
          return false; }}}
    // -----------------------------------------------------------------/
    private String getQuery(String host,String port,String dbname
                           ,String user,String pswd) {
      // Definicja zmiennych metody.
      char[] buffer;
      int count = 0;
      int length = 0;
      String data = null;
      String[] type;
      StringBuffer sb;

      try {
        // Ustawienie rdowej puli pocze.
        OracleDataSource ods = new OracleDataSource();
        String url = "jdbc:oracle:thin:@//"+host+":"+port+"/"+dbname;
        ods.setURL(url);
        ods.setUser(userid);
        ods.setPassword(passwd);

        // Definicja poczenia.
        Connection conn = ods.getConnection();

        // Definicja obiektu zawierajcego metadane.
        DatabaseMetaData dmd = conn.getMetaData();

        // Tworzenie instrukcji.
        Statement stmt = conn.createStatement();

        // Wykonywanie zapytania.
        ResultSet rset =
          stmt.executeQuery(
            "SELECT item_desc " +
            "FROM   item " +
            "WHERE  item_title = " +
            "'The Lord of the Rings - Fellowship of the Ring'"+
            "AND    item_subtitle = 'Widescreen Edition'");

        // Pobieranie metadanych, okrelanie rozmiaru tablicy i przypisywanie wartoci kolumn.
        ResultSetMetaData rsmd = rset.getMetaData();
        type = new String[rsmd.getColumnCount()];
        for (int col = 0;col < rsmd.getColumnCount();col++)
          type[col] = rsmd.getColumnTypeName(col + 1);

        // Wczytywanie wierszy i pobieranie wartoci z kolumn typu CLOB.
        while (rset.next()) {
          for (int col = 0;col < rsmd.getColumnCount();col++) {
            if (type[col] == "CLOB") {
              // Przypisywanie zbioru wynikw do zmiennej typu CLOB.
              Clob clob = rset.getClob(col + 1);

              // Sprawdzanie, czy zbir nie ma wartoci null, i wczytywanie strumienia 
              // znakw.
              if (clob != null) {
                Reader is = clob.getCharacterStream();

                // Inicjowanie zmiennych lokalnych.
                sb = new StringBuffer();
                length = (int) clob.length();

                // Sprawdzanie, czy zbir wnikw nie jest pusty.
                if (length > 0) {
                  // Inicjowanie struktur sterujcych w celu wczytania strumienia.
                  buffer = new char[length];
                  count = 0;

                  // Wczytanie strumienia i doczenie danych do bufora StringBuffer.
                  try {
                    while ((count = is.read(buffer)) != -1)
                      sb.append(buffer);

                    // Przypisanie bufora StringBuffer do zmiennej typu String.
                    data = new String(sb); }
                  catch (Exception e) {} }
                else
                  data = (String) null; }
              else
                data = (String) null; }
            else {
              data = (String) rset.getObject(col + 1); }}}

        // Zamknicie zasobw.
        rset.close();
        stmt.close();
        conn.close();

        // Zwrcenie danych typu CLOB jako acucha znakw.
        return data; }
      catch (SQLException e) {
        if (e.getSQLState() == null) {
          System.out.println(
            new SQLException("Bd uproszczonego klienckiego poczenia Oracle Net8.",
                             "ORA-" + e.getErrorCode() +
                             ": Bdne argumenty uproszczonego klienta Net8:\n\n" +
                             "  nazwa serwera [" + host + "]\n" +
                             "  numer portu   [" + port + "]\n" +
                             "  nazwa bazy    [" + dbname + "]\n"
                             , e.getErrorCode()).getSQLState());

          // Zwrcenie pustego acucha znakw po wystpieniu bdu.
          return data; }
        else {
          System.out.println(e.getMessage());
          return data; }}
        finally {
          if (data == null) System.exit(1); }}}
  // -----------------------------------------------------------------/
  public static void main(String[] args) {
    // Definicja okna.
    WriteReadCLOB frame = new WriteReadCLOB("Zapis i odczyt danych typu CLOB"); }}

