// --------------------------------------------------------------------
// ReadBFILE.java
// Dodatek D, Oracle Database 11g. Programowanie w jzyku PL/SQL
// Michael McLaughlin
//
// Ten kod ilustruje wczytywanie pliku obrazu i wywietlanie
// go w obiekcie typu JLabel w ramce JFrame.
// --------------------------------------------------------------------

// Importowanie niezbdnych klas.
import java.awt.GridLayout;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

// Importowanie oglnych klas do obsugi pocze JDBC.
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Types;

// Importowanie klas bazy danych Oracle do obsugi pocze JDBC  .
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.pool.OracleDataSource;

// Doczenie bibliotek opisanych w ksice (dostpnych w witrynie wydawnictwa).
import plsql.jdbc.DataConnectionPane;
import plsql.jdbc.DataTablePane;
// -----------------------------------------------------------------/
public class ReadBFILE extends JFrame {
  // Definiowanie poczenia z baz danych.
  private String host;
  private String port;
  private String dbname;
  private String userid;
  private String passwd;

  // Definicje zmiennych uywanych w zapytaniu.
  private String tableName;
  private String columnName;
  private String keyColumnName;
  private String keyColumnValue;
  private String operatingSystem;

  // Definicje paneli poczenia i zapytania.
  private DataConnectionPane message = new DataConnectionPane();
  private DataTablePane table = new DataTablePane(DataTablePane.TABLE_COLUMN_KEY);

  // Kod klasy.
  public ReadBFILE (String s) {
    super(s);

    // Pobranie wartoci poczenia z baz danych lub zakoczenie dziaania programu.
    if (JOptionPane.showConfirmDialog(this,message
         ,"Podaj wartoci acucha znakw poczenia z Oracle"
         ,JOptionPane.OK_CANCEL_OPTION) == 0) {

    // Ustawienie zmiennych poczenia.
    host = message.getHost();
    port = message.getPort();
    dbname = message.getDatabase();
    userid = message.getUserID();
    passwd = message.getPassword();

    // Wywietlenie informacji o poczeniu w oknie konsoli (narzdzie diagnostyczne).
    message.getConnection();

    // Pobieranie parametrw zapytania.
    if (JOptionPane.showConfirmDialog(this,table
         ,"Podaj wartoci acucha znakw poczenia z Oracle"
         ,JOptionPane.OK_CANCEL_OPTION) == 0) {

        // Ustawienie zmiennych zapytania. 
        tableName = table.getTableName();
        columnName = table.getColumnName();
        keyColumnName = table.getKeyColumnName();
        keyColumnValue = table.getKeyColumnValue();
        operatingSystem = table.getOperatingSystem();

        // Wywietlanie zmiennych zapytania zapisanych w tabeli.
        table.getTable(); }
      else
        System.exit(2);

      // Tworzenie panelu JPanel w celu wywietlenia danych.
      ManageBFILE panel = new ManageBFILE();

      // Konfigurowanie panelu JPanel.
      panel.setOpaque(true);
      setContentPane(panel);

      // Konfigurowanie ramki JFrame.
      setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
      setLocation(100,100);
      pack();
      setVisible(true); }
    else
      System.exit(1); }
  // -----------------------------------------------------------------/
  private class ManageBFILE extends JPanel {
    // Zmienne suce do wczytywania i wywietlania obrazw z plikw BFILE.
    private BufferedImage image;
    private JLabel label;
    private String canonicalFileName;
// -----------------------------------------------------------------/
  public ManageBFILE () {

    // Ustawienie menedera wywietlania.
    super(new GridLayout(1,0));

    // Kierowanie zapytania do bazy danych i wczytywanie kanonicznej nazwy pliku.
    canonicalFileName = getQuery(host,port,dbname,userid,passwd);

    try {
      image = ImageIO.read(new File(canonicalFileName)); }
    catch (IOException e) {
      System.out.println(e.getMessage()); 
      System.exit(3);}
     
    // Umieszczanie obrazu w kontenerze i dodawanie kontenera do panelu JPanel.
    label = new JLabel(new ImageIcon(image));
    add(label); }
  // -----------------------------------------------------------------/
  private String getQuery(String host,String port,String dbname
                         ,String user,String pswd) {

    // Definicja zwracanej zmiennej.
    String data = null;

    try {
      // Ustawianie rdowej puli pocze.
      OracleDataSource ods = new OracleDataSource();
      String url = "jdbc:oracle:thin:@//" + host + ":" + port + "/" + dbname;
      ods.setUrl(url);
      ods.setUser(user);
      ods.setPassword(passwd);

      // Definicja poczenia.
      Connection conn = ods.getConnection();

      // Tworzenie instrukcji.
      CallableStatement stmt =
        conn.prepareCall("BEGIN " +
                         "  ? := get_canonical_bfilename(?,?,?,?);" +
                         "END;");

      // Rejestrowanie zmiennej w trybie OUT.
      stmt.registerOutParameter(1,Types.VARCHAR);

      // Rejestrowanie zmiennych w trybie IN.
      stmt.setString(2,tableName);
      stmt.setString(3,columnName);
      stmt.setString(4,keyColumnName);
      stmt.setString(5,keyColumnValue);
      stmt.setString(6,operatingSystem);

      // Wykonywanie zapytania.
      if (stmt.execute());

      // Wczytywanie wierszy, a nastpnie danych tylko z kolumny typu CLOB.
      data = (String) stmt.getString(1);

      // Zamykanie zasobw.
      stmt.close();
      conn.close();

      // Zwrcenie danych typu CLOB jako acucha znakw.
      return data; } 
    catch (SQLException e) {
      if (e.getSQLState() == null) {
        System.out.println(
            new SQLException("Bd uproszczonego klienckiego poczenia Oracle Net8.",
                      "ORA-" + e.getErrorCode() +
                      ": Bdne argumenty uproszczonego klienta Net8:\n\n" +
                      "  nazwa serwera [" + host + "]\n" +
                      "  numer portu   [" + port + "]\n" +
                      "  nazwa bazy    [" + db + "]\n",
                      e.getErrorCode()).getSQLState()); }

        // Zwrcenie pustego acucha znakw po wystpieniu bdu.
        return data; }
      else { System.out.println("here");
        System.out.println(e.getMessage());

        // Zwrcenie pustego acucha znakw po wystpieniu bdu.
        return data; }}
      finally {
		if (data == null) System.exit(1); }}
  // -----------------------------------------------------------------/
  public static void main(String[] args) {
    ReadBFILE frame = new ReadBFILE("Wczytany obraz BFILE"); }}

