/*
 * create_items2.sql
 * Rozdzia 16., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt tworzy dynamiczn stron internetow opart na PL/SQL-u.
 * Uyto tu elastycznego przekazywania parametrw.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

CREATE OR REPLACE PROCEDURE item2
( name_array    OWA_UTIL.ident_ARR
, value_array   OWA_UTIL.ident_ARR ) AS

  CURSOR get_items
  ( begin_item_id NUMBER
  , end_item_id   NUMBER ) IS
    SELECT   item_id AS item_number
    ,        item_title||': '||item_subtitle AS item_title
    ,        item_release_date AS release_date
    FROM     item
    WHERE    item_id BETWEEN begin_item_id AND end_item_id;
BEGIN
  -- Przygotowanie znacznikw HTML.
  htp.htmlopen;
  htp.headopen;
  htp.htitle('Item List');  -- Okrela nagwek okna przegldarki i strony.
  htp.headclose;
  htp.bodyopen;
  htp.line;

  -- Uycie narzdzia PL/SQL Toolkit do sformatowania strony.
  htp.tableopen(cborder     => 2
               ,cattributes => 'style=background-color:feedb8');
    htp.tablerowopen;
      htp.tabledata(cvalue      => 'Numer'
                   ,calign      => 'center'
                   ,cattributes => 'style=color:#336699
                                          background-color:#cccc99
                                          font-weight:bold
                                          width=50');
      htp.tabledata(cvalue      => 'Tytu'
                   ,calign      => 'center'
                   ,cattributes => 'style=color:#336699
                                          background-color:#cccc99
                                          font-weight:bold
                                          width=200');
      htp.tabledata(cvalue      => 'Data wydania'
                   ,calign      => 'center'
                   ,cattributes => 'style=color:#336699
                                          background-color:#cccc99
                                          font-weight:bold
                                          width=100');
    htp.tablerowclose;

  -- Pobieranie danych w ptli.
  FOR i IN get_items(name_array(1),value_array(2)) LOOP

    htp.tablerowopen;
      htp.tabledata(cvalue      => i.item_number
                   ,calign      => 'center'
                   ,cattributes => 'style=background-color:#f7f7e7');
      htp.tabledata(cvalue      => i.item_title
                   ,calign      => 'left'
                   ,cattributes => 'style=background-color:#f7f7e7');
      htp.tabledata(cvalue      => i.release_date
                   ,calign      => 'center'
                   ,cattributes => 'style=background-color:#f7f7e7');
    htp.tablerowclose;

  END LOOP;

  -- Zakoczenie tabeli.
  htp.tableclose;

  -- Wywietlenie linii i zakoczenie ciaa oraz caej strony.
  htp.line;
  htp.bodyclose;
  htp.htmlclose;

END item2;
/
