/*
 * HelloWorld4e.sql
 * Rozdzia 15., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt tworzy nakadk jzyka PL/SQL na plik klasy jzyka Java.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

-- Usuwa obiekty, aby mona wielokrotnie uruchomi skrypt.
BEGIN

  FOR i IN (SELECT   table_name
            FROM     user_tables
            WHERE    table_name = 'JAVA_DEBUG' ) LOOP
            
    -- Uywa instrukcji NDS do usunicia zalenego typu obiektowego.
    EXECUTE IMMEDIATE 'DROP TABLE java_debug';
    
  END LOOP;
  
END;
/

-- Tworzy tabel potrzebn w skrypcie.
CREATE TABLE java_debug
( debug_id    NUMBER
, debug_value VARCHAR2(2000));


-- Tworzy pakiet jzyka PL/SQL bdcy nakadk na plik klasy jzyka Java.
CREATE OR REPLACE TYPE hello_world4 AS OBJECT
EXTERNAL NAME 'HelloWorld4' LANGUAGE JAVA
USING SQLData
( instanceName VARCHAR2(100) EXTERNAL NAME 'java.lang.String'
, CONSTRUCTOR FUNCTION hello_world4
  RETURN SELF AS RESULT
, CONSTRUCTOR FUNCTION hello_world4
  ( instanceName VARCHAR2 )
  RETURN SELF AS RESULT
, MEMBER FUNCTION getQualifiedName
  RETURN VARCHAR2 AS LANGUAGE JAVA
  NAME 'HelloWorld4.getQualifiedName() return java.lang.String'
, MEMBER FUNCTION getSQLTypeName
  RETURN VARCHAR2 AS LANGUAGE JAVA
  NAME 'HelloWorld4.getSQLTypeName() return java.lang.String' )
INSTANTIABLE FINAL;
/

-- Blok anonimowy do testowania typu.
DECLARE

  -- Definiowanie i tworzenie egzemplarzy typu obiektowego.
  my_obj1 hello_world4 := hello_world4('Adam');
  my_obj2 hello_world4 := hello_world4('Eve');
  
  PROCEDURE write_debug
  ( number_in NUMBER
  , value_in  VARCHAR2 ) IS
  
  BEGIN
  
    INSERT INTO java_debug VALUES (number_in,value_in);
    
  END write_debug;
  
BEGIN

  -- Testowanie egzemplarza klasy.
  dbms_output.put_line('Element nr 1: ['||my_obj1.getQualifiedName||']');
  write_debug(101, 'Element nr 1 jest gotowy');
  dbms_output.put_line('Element nr 2: ['||my_obj2.getQualifiedName||']');
  write_debug(102, 'Element nr 2 jest gotowy.');
  dbms_output.put_line('Element nr 3: ['||my_obj1.getSQLTypeName||']');
  write_debug(103, 'Element nr 3 jest gotowy.');
  dbms_output.put_line('Element nr 4: ['||my_obj1.getSQLTypeName||']');
  write_debug(104, 'Element nr 4 jest gotowy.');
  
  -- Testowanie repozytorium metadanych za pomoc pakietu DBMS_JAVA.
  dbms_output.put_line(
    'Element nr 5: ['||user||'.'||dbms_java.longname('HELLO_WORLD4')||']');

END;
/