/*
 * writestr2.c
 * Rozdzia 13., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt otwiera plik i zapisuje pojedynczy wiersz tekstu
 * do pliku. Jest uywany w poczeniu ze skryptem
 * create_library2.sql
 *
 * Instrukcje kompilacji przedstawione s poniej. Trzeba zainstalowa
 * kompilator jzyka C w lokalnym systemie. Bez takiego kompilatora
 * kompilacja nie bdzie moliwa.
 * Naley wykona nastpujce operacje:
 *  - Skompilowa ten kod do biblioteki wspdzielonej w systemie UNIX
 *    (rozszerzenie *.so) lub do biblioteki doczanej dynamicznie
 *    (*.DLL) w systemie Windows.
 *  - W systemie UNIX bibliotek wspdzielon mona skompilowa
 *    na dwa sposoby. Podejmy je poniej:
 *    - Solaris: gcc -G -o sample.so sample.c
 *    - GNU:     gcc -shared -o sample.so sample.c
 *  - Zakadamy, e rodowisko IDE Microsoftu jest dobrze zaprojektowane
 *    i zawiera wiadmoci pomocne w kompilacji biblioteki DLL.
 */

/* Doczanie standardowej biblioteki wejcia-wyjcia */
#include <stdio.h>

/* Deklaracja funkcji writestr */
void writestr2(char *path, int message)
{
  /* Deklaracja zmiennej FILE */
  FILE *file_name;

  /* Otwarcie pliku */
  file_name = fopen(path,"w");

  /* Zapis otrzymanego komunikatu do pliku */
  fprintf(file_name,"%s\n",message);

  /* Zamknicie pliku */
  fclose(file_name);

}
