/*
 * waitone.sql
 * Rozdzia 12., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt oczekuje na alert z pakietu DBMS_ALERT, ktry jest
 * uruchamiany przy poleceniach DML na tabeli MESSAGES
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

-- Wywoanie skryptw potrzebnych w tym programie
@register_interest.sql

-- Rejestruje zainteresowanie alertem
DECLARE

  -- Definicja zmiennych w trybie OUT potrzebnych w procedurze WAITONE
  message        VARCHAR2(30 CHAR);
  status         INTEGER;

BEGIN

  -- Rejestrowanie zainteresowania alertem
  DBMS_ALERT.WAITONE('EVENT_MESSAGE_QUEUE'
                    ,message
                    ,status
                    ,30);

  IF (STATUS <> 0) THEN

    -- Wywietlanie komunikatu o bdzie
    DBMS_OUTPUT.PUT_LINE('Przekroczono limit czasu.');

  ELSE

    -- Wywietlanie nagwka
    DBMS_OUTPUT.PUT_LINE('Otrzymano alert');
    DBMS_OUTPUT.PUT_LINE('----------------');

    -- Wywietlanie otrzymanego komunikatu alertu

    DBMS_OUTPUT.PUT_LINE(message);

  END IF;

END;
/

-- Uycie SQL*Plus do sformatowania kolumn
COL message FORMAT A30

-- Pobranie listy wszystkich wysanych komunikatw
SELECT * FROM messages_alerts;
