/*
 * create_signal_triggers.sql
 * Rozdzia 12., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt tworzy wyzwalacz, ktry DBMS_ALERT uruchamia dla
 * zdarze zwizanych z tabel MESSAGES
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

-- Usunicie wyzwalacza, jeli ju istnieje
BEGIN
  FOR i IN (SELECT null
            FROM user_triggers
            WHERE trigger_name = 'SIGNAL_MESSAGES') LOOP
    EXECUTE IMMEDIATE 'DROP TRIGGER signal_messages';
  END LOOP;
END;
/

-- Tworzenie potrzebnej tabeli
@create_messages_table.sql

-- Tworzenie wyzwalacza
CREATE OR REPLACE TRIGGER signal_messages
AFTER
INSERT OR UPDATE OR DELETE
OF message_id
  ,message_source
  ,message_destination
  ,message
ON messages
FOR EACH ROW

BEGIN

  -- Sprawdza, czy nie istniay wczeniejsze wiersze (wstawianie)
  IF :old.message_id IS NULL THEN
  
    -- Sygnalizuje zdarzenie
    DBMS_ALERT.SIGNAL(
      'EVENT_MESSAGE_QUEUE'
      ,:new.message_source||':Wstawianie');

    -- Wstawianie komunikatu alertu
    INSERT
    INTO     messages_alerts
    VALUES   (:new.message_source||':Wstawianie');

  -- Sprawdza, czy wiersze nie bd istniay po poleceniu DML (usuwanie)
  ELSIF :new.message_id IS NULL THEN

    -- Sygnalizuje zdarzenie
    DBMS_ALERT.SIGNAL(
      'EVENT_MESSAGE_QUEUE'
      ,:old.message_source||':Usuwanie');

    -- Wstawianie komunikatu alertu
    INSERT
    INTO     messages_alerts
    VALUES   (:old.message_source||':Usuwanie');

  -- Ten kod obsuguje polecenia DML suce do aktualizacji
  ELSE

    -- Sprawdza, czy komunikat rdowy zosta zmodyfikowany (aktualizacja)
    IF :new.message_source IS NULL THEN

      -- Sygnalizuje zdarzenie
      DBMS_ALERT.SIGNAL(
        'EVENT_MESSAGE_QUEUE'
        ,:new.message_source||':Aktualizacja#1');

      -- Wstawia komunikat alertu
      INSERT
      INTO     messages_alerts
      VALUES   (:new.message_source||'Aktualizacja#1');

    -- Zmodyfikowano inn kolumn, a nie message_source 
    ELSE

      -- Sygnalizuje zdarzenie
      DBMS_ALERT.SIGNAL(
        'EVENT_MESSAGE_QUEUE'
        ,:old.message_source||':Aktualizacja#2');

      -- Wstawia komunikat alertu
      INSERT
      INTO     messages_alerts
      VALUES   (:old.message_source||':Aktualizacja#2');

    END IF;

  END IF;

END;
/
