/*
 * create_messages_table.sql
 * Rozdzia 12., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt tworzy tabel na komunikaty pakietu DBMS_ALERT
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

BEGIN
  FOR i IN (SELECT null
            FROM user_tables
            WHERE table_name = 'MESSAGES') LOOP
    EXECUTE IMMEDIATE 'DROP TABLE messages CASCADE CONSTRAINTS';
  END LOOP;
END;
/

BEGIN
  FOR i IN (SELECT null
            FROM user_tables
            WHERE table_name = 'MESSAGES_ALERTS') LOOP
    EXECUTE IMMEDIATE 'DROP TABLE messages_alerts CASCADE CONSTRAINTS';
  END LOOP;
END;
/

CREATE TABLE messages
(message_id               INTEGER             NOT NULL
,message_source           VARCHAR2(30 CHAR)   NOT NULL
,message_destination      VARCHAR2(30 CHAR)   NOT NULL
,message                  VARCHAR2(30 CHAR)   NOT NULL
,CONSTRAINT message_pk    PRIMARY KEY (message_id));

INSERT
INTO     messages
VALUES (1,'PLSQL','USERA','Szykuj sie do akcji!');

INSERT
INTO     messages
VALUES (2,'PLSQL','USERA','Spotkajmy sie w Krakowie');

INSERT
INTO     messages
VALUES (3,'PLSQL','USERA','Wyplacz sie w poduszke.');

CREATE TABLE messages_alerts
(message                  VARCHAR2(30 CHAR)   NOT NULL);
