/*
 * create_nds7.sql
 * Rozdzia 11., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt NDS uywa miejsc na dane i zmiennych powizanych do
 * wczytywania i zapisywania wartoci w bloku anonimowym jzyka PL/SQL.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

CREATE OR REPLACE PROCEDURE get_clob
( item_title_in  VARCHAR2, item_desc_out IN OUT CLOB ) IS
BEGIN
  UPDATE  item
  SET     item_desc = empty_clob()
  WHERE   item_id = 
           (SELECT item_id
            FROM   item
            WHERE  item_title = item_title_in)
            RETURNING item_desc INTO item_desc_out;
END get_clob;
/

DECLARE
  -- Jawna definicja struktury rekordowej.
  target  CLOB;
  source  VARCHAR2(2000) := 'Klasyczny film w reyserii Mela Brooksa!';
  movie   VARCHAR2(60) := 'Young Frankenstein';
  stmt    VARCHAR2(2000);
BEGIN
  -- Przygotowanie instrukcji.
  stmt := 'BEGIN '
       || '  get_clob(:input,:output); '
       || 'END;';
  EXECUTE IMMEDIATE stmt USING movie, IN OUT target;
  dbms_lob.writeappend(target,LENGTH(source),source);
  COMMIT;
END;
/
