/*
 * create_nds5.sql
 * Rozdzia 11., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt NDS uywa miejsc na dane i zmiennych powizanych do
 * zwrcenia wartoci z zapytania za pomoc operacji masowych.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

DECLARE
  -- Jawna definicja struktury rekordowej.
  TYPE title_record IS RECORD
  ( item_title     VARCHAR2(60)
  , item_subtitle  VARCHAR2(60));
  TYPE title_collection IS TABLE OF TITLE_RECORD;
  -- Definicje zmiennych na potrzeby instrukcji dynamicznej.
  title_cursor  SYS_REFCURSOR;
  titles   	     TITLE_COLLECTION;
  stmt          VARCHAR2(2000);
BEGIN
  -- Przygotowanie instrukcji.
  stmt := 'SELECT  item_title, item_subtitle '
       || 'FROM    item '
       || 'WHERE   SUBSTR(item_title,1,12) = :input';
  
  -- Otwarcie i wczytanie kursora dynamicznego oraz zamknicie go.
  OPEN title_cursor FOR stmt USING 'Harry Potter';
  FETCH title_cursor BULK COLLECT INTO titles;

  FOR i IN 1..titles.COUNT LOOP
    dbms_output.put_line(
      '['||titles(i).item_title||']['||titles(i).item_subtitle||']');
  END LOOP;
  CLOSE title_cursor;
END;
/

