/*
 * create_dbms_sql5.sql
 * Rozdzia 11., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt uywa pakietu DBMS_SQL do pobrania wicej ni jednego wiersza.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

DECLARE
  c                         INTEGER := dbms_sql.open_cursor;
  fdbk                      INTEGER;
  statement                 VARCHAR2(2000);
  item1                     NUMBER := 1003;
  item2                     NUMBER := 1013;
  item_title                VARCHAR2(60);
  item_subtitle             VARCHAR2(60);

BEGIN

  -- Tworzenie i przetwarzanie instrukcji SQL.
  statement := 'SELECT item_title, item_subtitle '
            || 'FROM item '
            || 'WHERE item_id BETWEEN :item1 AND :item2 '
            || 'AND item_type = 1014';
  dbms_sql.parse(c,statement,dbms_sql.native);

  -- Odwzorowywanie kolumn i wykonywanie instrukcji.
  dbms_sql.define_column(c,1,item_title,60);    -- Definicja zmiennej w trybie OUT.
  dbms_sql.define_column(c,2,item_subtitle,60); -- Definicja zmiennej w trybie OUT.
  dbms_sql.bind_variable(c,'item1',item1);      -- Zmienna powizana o trybie IN.
  dbms_sql.bind_variable(c,'item2',item2);      -- Zmienna powizana o trybie IN.
  fdbk := dbms_sql.execute(c);
  
  -- Wczytywanie wynikw.
  LOOP
    EXIT WHEN dbms_sql.fetch_rows(c) = 0;       -- Brak dalszych wynikw.
    -- Kopiowanie i wywietlanie.
    dbms_sql.column_value(c,1,item_title);      -- Kopiowanie wartoci kolumny z zapytania do zmiennej.
    dbms_sql.column_value(c,2,item_subtitle);   -- Kopiowanie wartoci kolumny z zapytania do zmiennej.

    dbms_output.put_line('['||item_title||']['||NVL(item_subtitle,'None')||']');
    
  END LOOP;
  dbms_sql.close_cursor(c);

END;
/