/*
 * create_signon_trigger.sql
 * Rozdzia 10., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Tworzy wyzwalacze.
 */

CREATE OR REPLACE TRIGGER connection_log_t1
  BEFORE INSERT ON connection_log
  FOR EACH ROW
  WHEN (new.event_id IS NULL)
BEGIN
  SELECT  connection_log_s1.nextval
  INTO    :new.event_id
  FROM    dual;
END;
/

CREATE OR REPLACE TRIGGER compound_connection_log_t1
  FOR INSERT ON connection_log
  COMPOUND TRIGGER
  BEFORE EACH ROW IS
  BEGIN
    IF :new.event_id IS NULL THEN
      :new.event_id := connection_log_s1.nextval;
    END IF;
  END BEFORE EACH ROW;
END;
/


