/*
 * create_package_variables.sql
 * Rozdzia 9., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt ilustruje zarzdzanie wspuytkowanymi
 * zmiennymi pakietu.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

CREATE OR REPLACE PACKAGE package_variables IS
  PRAGMA SERIALLY_REUSABLE;
  -- Deklaracja komponentw pakietu.
  PROCEDURE set(value VARCHAR2);
  FUNCTION get RETURN VARCHAR2;
END package_variables;
/

show errors

CREATE OR REPLACE PACKAGE BODY package_variables IS
  PRAGMA SERIALLY_REUSABLE;
  -- Deklaracja zmiennej dostpnej w zasigu pakietu.
  variable VARCHAR2(20) := 'Warto pocztkowa';

  -- Definicja funkcji.
  FUNCTION get RETURN VARCHAR2 IS
  BEGIN
    RETURN variable;
  END get;

  -- Definicja procedury.
  PROCEDURE set(value VARCHAR2) IS
  BEGIN
    variable := value;
  END set;
END package_variables;
/

VARIABLE outcome VARCHAR2(20)

CALL package_variables.get() INTO :outcome;

SELECT :outcome AS outcome FROM dual;

EXECUTE package_variables.set('Nowa warto');

CALL package_variables.get() INTO :outcome;

SELECT :outcome AS outcome FROM dual;

