/*
 * varray_dml3.sql
 * Rozdzia 7., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt tworzy tablice VARRAY i ilustruje korzystanie z nich.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

DECLARE
  TYPE address_type IS RECORD
  ( address_id          INTEGER
  , individual_id       INTEGER
  , street_address      STRINGS
  , city                VARCHAR2(20 CHAR)
  , state               VARCHAR2(20 CHAR)
  , postal_code         VARCHAR2(20 CHAR)
  , country_code        VARCHAR2(10 CHAR));
  address              ADDRESS_TYPE;

  CURSOR get_street_address
    (address_id_in      INTEGER) IS
    SELECT   *
    FROM     addresses
    WHERE    address_id = address_id_in;
BEGIN
  -- Uzyskanie dostpu do kursora.
  OPEN  get_street_address(11);
  FETCH get_street_address INTO  address;
  CLOSE get_street_address;

  -- Modyfikacja pierwszego elementu zmiennej typu VARRAY.
  address.street_address(1) := 'Biuro senatora Jana Kowalskiego';

  -- Aktualizacja wartoci kolumny odpowiadajcej typowi VARRAY.
  UPDATE   addresses
  SET      street_address = address.street_address
  WHERE    address_id = 1;
END;
/

-- Zastosowanie SQL*Plus do sformatowania danych wyjciowych.
COL column_value FORMAT A30

-- Wywietlenie listy sformatowanych elementw tabeli zoonej. 
SELECT   *
FROM     TABLE(SELECT   CAST(street_address AS
                             varray_nested_table) 
               FROM     addresses
               WHERE    address_id = 1);
