/*
 * varray_dml2.sql
 * Rozdzia 7., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt tworzy tablice VARRAY i ilustruje korzystanie z nich.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

UPDATE   addresses
SET      street_address =
           strings('Biuro senatora Kowalskiego'
                   , 'Wschodnia 7',
                   , 'Pokj nr 1150')
WHERE    address_id = 1;

-- Zastosowanie SQL*Plus do sformatowania danych wyjciowych.
COL column_value FORMAT A30

-- Wywietlenie listy sformatowanych elementw tabeli zoonej.
SELECT   *
FROM     TABLE(SELECT   CAST(street_address AS
                             varray_nested_table) 
               FROM     addresses
               WHERE    address_id = 1);
