/*
 * nestedtable_dml3.sql
 * Rozdzia 7., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt tworzy tablice zagniedone i ilustruje korzystanie z nich.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

INSERT INTO individuals VALUES
( individuals_s1.nextval, 'Maciej', 'Zbigniew', 'Opolski', 'Pan');

INSERT INTO addresses VALUES
( addresses_s1.nextval
, individuals_s1.currval
, address_table('Biuro senatora Opolskiego')
,'Opole'
,'OPO'
,'02-203'
,'PL');

DECLARE
  TYPE address_type IS RECORD
  ( address_id          INTEGER
  , individual_id       INTEGER
  , street_address      ADDRESS_VARRAY
  , city                VARCHAR2(20 CHAR)
  , state               VARCHAR2(20 CHAR)
  , postal_code         VARCHAR2(20 CHAR)
  , country_code        VARCHAR2(10 CHAR));
  address               ADDRESS_TYPE;

  -- Definicja kursora zwracajcego warto %ROWTYPE
  CURSOR get_street_address
    (address_id_in      INTEGER) IS
    SELECT   *
    FROM     addresses
    WHERE    address_id = address_id_in;
BEGIN
  -- Uzyskanie dostpu do kursora.
  OPEN  get_street_address(2);
  FETCH get_street_address INTO  address;
  CLOSE get_street_address;

  -- Dodawanie elementw.
  address.street_address.EXTEND(2);
  address.street_address(2) := 'Biurowiec NOT-u';
  address.street_address(3) := 'Pokj nr 2400';

  -- Aktualizacja wartoci kolumny tabeli
  UPDATE   addresses
  SET      street_address = address.street_address
  WHERE    address_id = 2;
END;
/

-- Wywietlenie listy sformatowanych elementw tabeli zoonej.
SELECT   *
FROM     TABLE(SELECT   street_address 
               FROM     addresses
               WHERE    address_id = 1);

