/*
 * nestedtable_dml3.sql
 * Rozdzia 7., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt tworzy tablice zagniedone i ilustruje korzystanie z nich.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

UPDATE   TABLE(SELECT   street_address
               FROM     addresses
               WHERE    address_id = 1)
SET      column_value = 'Biuro senatora Jana Kowalskiego'
WHERE    column_value = 'Biuro senatora Kowalskiego';

-- Wywietlenie listy sformatowanych elementw tabeli zoonej.
SELECT   *
FROM     TABLE(SELECT   street_address 
               FROM     addresses
               WHERE    address_id = 1);

DECLARE
  -- Definicja starej i nowej wartoci
  new_value VARCHAR2(30 CHAR) := 'Biuro senatora Jana Kowalskiego';
  old_value VARCHAR2(30 CHAR) := 'Biuro senatora Kowalskiego';

  -- Utworzenie instrukcji SQL do obsugi zmiennych powizanych.
  sql_statement VARCHAR2(100 CHAR)
    := 'UPDATE   THE (SELECT   street_address '
    || '              FROM     addresses '
    || '              WHERE    address_id = 21) '
    || 'SET      column_value = :1 '
    || 'WHERE    column_value = :2';
BEGIN
  -- Zastosowanie dynamicznego SQL do wykonania instrukcji UPDATE. 
  EXECUTE IMMEDIATE sql_statement USING new_value, old_value;
END;
/

-- Wywietlenie listy sformatowanych elementw tabeli zoonej.
SELECT   *
FROM     TABLE(SELECT   street_address 
               FROM     addresses
               WHERE    address_id = 1);

