/*
 * nestedtable_dml1.sql
 * Rozdzia 7., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt tworzy tablice zagniedone i ilustruje korzystanie z nich.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000


INSERT INTO individuals VALUES
( individuals_s1.nextval, 'Jan', 'Piotr', 'Kowalski', 'Pan');

INSERT INTO addresses VALUES
( addresses_s1.nextval
, individuals_s1.currval
, strings
  ('Biuro senatora Kowalskiego'
  ,'Zachodnia 1'
  ,'Pokj nr 200')
,'Warszawa'
,'MAZ'
,'85-701'
,'PL');

SELECT   street_address
FROM     addresses;

-- Zastosowanie SQL*Plus do sformatowania danych wyjciowych.
COL column_value FORMAT A30

-- Wywietlenie listy sformatowanych elementw tabeli zoonej.
SELECT   *
FROM     TABLE(SELECT   street_address 
               FROM     addresses
               WHERE    address_id = 1);

CREATE OR REPLACE FUNCTION many_to_one
(street_address_in ADDRESS_TABLE) RETURN VARCHAR2 IS
  retval VARCHAR2(2000) := '';
BEGIN
  -- Wczytanie wszystkich elementw tabeli zagniedonej i dodanie do nich znaku koca wiersza.
  FOR i IN 1..street_address_in.COUNT LOOP
    retval := retval || street_address_in(i) || CHR(10);
  END LOOP;
  RETURN retval;
END many_to_one;
/

-- Zastosowanie SQL*Plus do sformatowania danych wyjciowych.
COL address_label FORMAT A30

-- Wywietlenie etykiety listu.
SELECT   i.first_name || ' '
||       i.middle_initial || ' '
||       i.last_name || CHR(10)
||       many_to_one(a.street_address)
||       city || ', '
||       state || ' '
||       postal_code address_label
FROM     addresses a
,        individuals i
WHERE    a.individual_id = i.individual_id
AND      i.individual_id = 1;

