/*
 * multiset.sql
 * Rozdzia 7., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt ilustruje uywanie operatorw zbiorw.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

CREATE OR REPLACE TYPE list IS TABLE OF NUMBER;
/

CREATE OR REPLACE FUNCTION format_list(set_in LIST) RETURN VARCHAR2 IS
  retval VARCHAR2(2000);
BEGIN
  IF set_in IS NULL THEN
    dbms_output.put_line('Wynik: <Null>');
  ELSIF set_in.COUNT = 0 THEN
    dbms_output.put_line('Wynik: <Empty>');
  ELSE
    FOR i IN set_in.FIRST..set_in.LAST LOOP
      IF i = set_in.FIRST THEN
        IF set_in.COUNT = 1 THEN
          retval := '('||set_in(i)||')';
        ELSE
          retval := '('||set_in(i);  
        END IF;
      ELSIF i <> set_in.LAST THEN
        retval := retval||', '||set_in(i);
      ELSE
        retval := retval||', '||set_in(i)||')';
      END IF;
    END LOOP;
  END IF;
  RETURN retval;
END format_list;
/


-- Operator MINUS przeznaczony do obsugi kolekcji.
DECLARE
  a LIST := list(1,2,3,4);
  b LIST := list(4,5,6,7);
BEGIN
  dbms_output.put_line(format_list(a MULTISET EXCEPT b)); 
END;
/

-- Operator INTERSECT przeznaczony do obsugi kolekcji.
DECLARE
  a LIST := list(1,2,3,4);
  b LIST := list(4,5,6,7);
BEGIN
  dbms_output.put_line(format_list(a MULTISET INTERSECT b)); 
END;
/

-- Operator UNION ALL przeznaczony do obsugi kolekcji.
DECLARE
  a LIST := list(1,2,3,4);
  b LIST := list(4,5,6,7);
BEGIN
  dbms_output.put_line(format_list(a MULTISET UNION b)); 
END;
/

-- Operator UNION przeznaczony do obsugi kolekcji.
DECLARE
  a LIST := list(1,2,3,4);
  b LIST := list(4,5,6,7);
BEGIN
  dbms_output.put_line(format_list(a MULTISET UNION DISTINCT b)); 
END;
/

-- Operator UNION przeznaczony do obsugi kolekcji.
DECLARE
  a LIST := list(1,2,3,4);
  b LIST := list(4,5,6,7);
BEGIN
  dbms_output.put_line(format_list(SET(a MULTISET UNION b))); 
END;
/

-- Operator SET przeznaczony do obsugi kolekcji.
DECLARE
  a LIST := list(1,2,3,3,4,4,5,6,6,7);
BEGIN
  dbms_output.put_line(format_list(SET(a))); 
END;
/
