/*
 * create_nestedtable4.sql
 * Rozdzia 7., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt tworzy tablice zagniedone i ilustruje korzystanie z nich.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

CREATE OR REPLACE TYPE card_unit_varray AS VARRAY(13) OF VARCHAR2(5 CHAR);
/
CREATE OR REPLACE TYPE card_suit_varray AS VARRAY(4) OF VARCHAR2(8 CHAR);
/
CREATE OR REPLACE TYPE card_deck_table AS TABLE OF VARCHAR2(17 CHAR);
/

DECLARE
  -- Deklaracja licznika.
  counter INTEGER := 0;

  -- Deklaracja i inicjowanie kolorw oraz nazw kart.
  suits CARD_SUIT_VARRAY :=
    card_suit_varray('Trefl','Karo','Kier','Pik');
  units CARD_UNIT_VARRAY :=
    card_unit_varray('As','Dwjka','Trjka','Czwrka','Pitka','Szstka','Sidemka'
                    ,'semka','Dziewitka','Dziesitka','Walet','Dama','Krl');
                    
  -- Deklaracja i inicjowanie pustej tabeli zagniedonej
  deck CARD_DECK_TABLE := card_deck_table(); 
BEGIN
  -- Przejcie w ptlach po 4 kolorach i 13 kartach.
  FOR i IN 1..suits.COUNT LOOP
    FOR j IN 1..units.COUNT LOOP
      counter := counter + 1;
      deck.EXTEND;
      deck(counter) := units(j)||' '||suits(i);
    END LOOP;
  END LOOP;

  -- Wywietlenie zainicjowanych wartoci.
  dbms_output.put_line('Talia kart wywietlona wedug kolorw.');
  dbms_output.put_line('--------------------------------------');
  FOR i IN 1..counter LOOP
    dbms_output.put_line('['||deck(i)||']');
  END LOOP;
END;
/

