/*
 * recursion.sql
 * Rozdzia 6., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt tworzy dwie funkcje rekurencyjne. Funkcja factorial
 * ilustruje rekurencj liniow, a funkcja fibonacci -
 * rekurencj nieliniow.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

-- Funkcja uywajca rekurencji liniowej.
CREATE OR REPLACE FUNCTION factorial
( n BINARY_DOUBLE ) RETURN BINARY_DOUBLE IS
BEGIN
  IF n <= 1 THEN
    RETURN 1;
  ELSE
    RETURN n * factorial(n - 1);
  END IF;
END factorial;
/

-- Funkcja uywajca rekurencji nieliniowej.
CREATE OR REPLACE FUNCTION fibonacci
( n BINARY_DOUBLE ) RETURN BINARY_DOUBLE IS
BEGIN
  IF n <= 2 THEN
    RETURN 1;
  ELSE
    RETURN fibonacci(n - 2) + fibonacci(n - 1);
  END IF;
END fibonacci;
/

  