/*
 * create_add_user.sql
 * Rozdzia 6., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt tworzy autonomiczn funkcj o parametrach 
 * przekazywanych przez warto.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

CREATE OR REPLACE FUNCTION add_user
( system_user_id    NUMBER
, system_user_name  VARCHAR2
, system_group_id   NUMBER
, system_user_type  NUMBER
, last_name         VARCHAR2
, first_name        VARCHAR2
, middle_initial    VARCHAR2
, created_by        NUMBER
, creation_date     DATE
, last_updated_by   NUMBER
, last_update_date  DATE ) RETURN BOOLEAN IS
  -- Okrelenie, e funkcja ma dziaa w niezalenym zasigu transakcji.
  PRAGMA AUTONOMOUS_TRANSACTION;
  -- Ustawienie domylnej zwracanej wartoci.
  retval BOOLEAN := FALSE;
BEGIN
  INSERT INTO system_user
  VALUES
  ( system_user_id, system_user_name, system_group_id, system_user_type
  , last_name, first_name, middle_initial
  , created_by, creation_date, last_updated_by, last_update_date );
  -- Zapisanie zmian w niezalenym zasigu transakcji.
  COMMIT;
  -- Ustawienie zwracanej wartoci.
  retval := TRUE;
  RETURN retval;
END;
/

-- Blok anonimowy testujcy funkcj add_user.
BEGIN
  IF add_user( 6,'Application DBA', 1, 1
             ,'Brown','Jerry',''
             , 1, SYSDATE, 1, SYSDATE) THEN
    dbms_output.put_line('Wstawiono rekord');
    ROLLBACK;
  ELSE
    dbms_output.put_line('Nie wstawiono rekordu');
  END IF;
END;
/

