/*
 * forall.sql
 * Rozdzia 4., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt ilustruje ptl FORALL.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

DECLARE
  TYPE id_collection IS TABLE OF NUMBER;
  TYPE title_collection IS TABLE OF VARCHAR2(60);
  TYPE subtitle_collection IS TABLE OF VARCHAR2(60);
  id       ID_COLLECTION;
  title    TITLE_COLLECTION;
  subtitle SUBTITLE_COLLECTION;
  CURSOR c IS
    SELECT  item_id
    ,       item_title
    ,       item_subtitle
    FROM    item;
BEGIN
  OPEN c;
  LOOP
    FETCH c BULK COLLECT INTO id, title, subtitle LIMIT 10;
    EXIT WHEN title.COUNT = 0;
    FORALL i IN id.FIRST..id.LAST
      INSERT INTO item_temp VALUES (id(i),title(i),subtitle(i));
  END LOOP;
  FOR i IN id.FIRST..id.LAST LOOP
    dbms_output.put('Wstawiono ['||id(i)||']');
    dbms_output.put_line('['||SQL%BULK_ROWCOUNT(i)||']');
  END LOOP;
END;
/






















