/*
 * cursor_for_loop.sql
 * Rozdzia 4., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt ilustruje ptl FOR opart na kursorze.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

BEGIN
  FOR i IN (SELECT    COUNT(*) AS on_hand
            ,         item_title
            ,         item_rating
            FROM      item
            WHERE     item_title LIKE 'Harry Potter%'
            AND       item_rating_agency = 'MPAA'
            GROUP BY  item_title
            ,         item_rating) LOOP
    dbms_output.put('('||i.on_hand||') ');
    dbms_output.put(i.item_title||' ');
    dbms_output.put_line('['||i.item_rating||']');
  END LOOP;
END;
/







