// --------------------------------------------------------------------
// ReadImage.java
// Dodatek D, Oracle Database 11g. Programowanie w jzyku PL/SQL
// Michael McLaughlin
//
// Ten kod ilustruje wczytywanie pliku obrazu i wywietlanie
// go w obiekcie typu JLabel w ramce JFrame.
// --------------------------------------------------------------------

// Importowanie niezbdnych plikw.
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import java.awt.GridLayout;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.File;
import javax.imageio.ImageIO;

// Doczenie bibliotek opisanych w ksice (mona je pobra z witryny wydawnictwa).
import plsql.jdbc.DataConnectionPane;
import plsql.fileio.FileIO;
// -------------------------------------------------------------------/
public class ReadImage extends JPanel {
  // Suy do wczytywania i wywietlania pliku typu BFILE zawierajcego obraz.
  private BufferedImage image;
  private JLabel label;
  // -----------------------------------------------------------------/
  public ReadImage () {
    // Ustawienie menedera ukadu ekranu.
    super(new GridLayout(1,0));

    // Wczytywanie pliku z obrazem.
    try {
      image = ImageIO.read(FileIO.findFile()); }
    catch (IOException e) {
      System.out.println(e.getMessage()); }

    // Umieszczanie obrazu w kontenerze i dodawanie kontenera do panelu JPanel.
    label = new JLabel(new ImageIcon(image));
    add(label); }
  // -----------------------------------------------------------------/
  public static void main(String[] args) {
    // Definicja okna.
    JFrame frame = new JFrame("Wczytywanie obrazu z pliku BFILE");

    // Definiowanie i konfigurowanie panelu.
    ReadImage panel = new ReadImage();
    panel.setOpaque(true);

    // Konfigurowanie okna i umoliwienie jego domylnego zamykania.
    frame.setContentPane(panel);

    frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    frame.setLocation(100,100);

    frame.pack();

    frame.setVisible(true); }}
