<html>
<! ReferenceCursor.php                                            >
<! Dodatek C, Oracle Database 11g. Programowanie w jzyku PL/SQL  >
<! Michael McLaughlin                                             >
<!                                                                >
<! Ten kod ilustruje wczytywanie pliku graficznego i wywietlanie >
<! go w etykiecie JLabel w ramce JFrame.                          >
<head>
<title>
  Dodatek C. ReferenceCursor .php
</title>
<style>
.e {background-color: #ccccff; font-weight: bold; color: #000000;}
.v {background-color: #cccccc; color: #000000;}
</style>
</head>
<body>

<?php
  // Sprawdzenie moliwoci nawizania poczenia z baz danych.
  if ($c = @oci_connect("php","php","xe"))
  {
    // Deklaracje zmiennych wejciowych.
    (isset($_GET['begin']))   ? $t_start = (int) $_GET['begin']
                              : $t_start = 1787;
    (isset($_GET['end']))     ? $t_end = (int) $_GET['end']
                              : $t_end = (int) date("Y",time());
    (isset($_GET['country'])) ? $country = $_GET['country']
                              : $country = "USA";

    // Deklaracja instrukcji w jzyku PL/SQL.
    $stmt = "BEGIN
               world_leaders.get_presidents(:term_start
                                           ,:term_end
                                           ,:country
                                           ,:return_cursor);
             END;";

    // Usuwanie znakw specjalnych, aby unikn bdw ORA-06550 i PLS-00103.
    $stmt = strip_special_characters($stmt);

    // Parsowanie zapytania przy uyciu poczenia.
    $s = oci_parse($c,$stmt);

    // Deklaracja kursora zwracanego za pomoc poczenia.
    $rc = oci_new_cursor($c);

    // Wizanie zmiennych jzyka PHP ze zmiennymi wejciowymi bibliotek OCI.
    oci_bind_by_name($s,':term_start',$t_start,SQLT_INT);
    oci_bind_by_name($s,':term_end',$t_end,SQLT_INT);
    oci_bind_by_name($s,':country',$country,SQLT_CHR);

    // Wizanie zmiennych jzyka PHP ze zmienn wyjciow bibliotek OCI.
    oci_bind_by_name($s,':return_cursor',$rc,-1,OCI_B_CURSOR);

    // Wykonanie instrukcji jzyka PL/SQL.
    oci_execute($s);

    // Uzyskanie dostpu do zwrconego kursora.
    oci_execute($rc);

    // Wywietlenie zrozumiaych nagwkw tabeli.
    print '<table border="1" cellpadding="3" cellspacing="0">';

    // Przypisanie wartoci true zmiennej okrelajcej, czy naley uy dynamicznych etykiet.
    $label = true;

    // Wczytanie zawartoci kursora referencyjnego.
    while($row = oci_fetch_assoc($rc))
    {
      // Deklaracje zmiennych header i data.
      $header = "";
      $data = "";

      // Wczytanie zawartoci kursora referencyjnego do tabeli.
      foreach ($row as $name => $column)
      {
        // Zapisanie etykiet w pierwszym wierszu.
        if ($label)
        {
          $header .= '<td class="e">'.$name.'</td>';
          $data .= '<td class="v">'.$column.'</td>';
        }
        else
          $data .= '<td class=v>'.$column.'</td>';
      }

      // Jednokrotne wywietlenie wiersza z nagwkiem.
      if ($label)
      {
        print '<tr>'.$header.'</tr>';
        $label = !$label;
      }

      // Wywietlenie wierszy z danymi.
      print '<tr>'.$data.'</tr>';

    }

    // Zamknicie tabeli HTML.
    print '</table>';

    // Zamknicie poczenia z baz danych.
    oci_close($c);
  }
  else
  {
    // Przypisanie bdu OCI i sformatowanie cudzysoww oraz apostrofw.
    $errorMessage = oci_error();
    print htmlentities($errorMessage['message'])."<br />";
  }

  // Usunicie znakw specjalnych, na przykad przejcia do nowego wiersza i tabulacji.
  function strip_special_characters($str)
  {
    $out = "";
    for ($i = 0;$i < strlen($str);$i++)
      if ((ord($str[$i]) != 9) && (ord($str[$i]) != 10) &&
          (ord($str[$i]) != 13))
        $out .= $str[$i];
    return $out;
  }
?>

</body>
</html>
