-- The SQL*Plus script collection_user2.sql performs the following:
--   1. Creates collection_user2
--   2. Creates the database object and collection types
--   3. Populates the database tables with example data

-- This script should be run by the system user (or the DBA)
CONNECT system/manager;

-- drop collection_user2
DROP USER collection_user2 CASCADE;

-- create collection_user2
CREATE USER collection_user2 IDENTIFIED BY collection_password;

-- allow collection_user2 to connect and create database objects
GRANT connect, resource TO collection_user2;

-- connect as collection_user2
CONNECT collection_user2/collection_password;


-- create the object and collection types
CREATE TYPE t_varray_phone AS VARRAY(3) OF VARCHAR2(14);
/

CREATE TYPE t_address AS OBJECT (
  street        VARCHAR2(15),
  city          VARCHAR2(15),
  state         CHAR(3),
  zip           VARCHAR2(5),
  phone_numbers t_varray_phone
);
/

CREATE TYPE t_nested_table_address AS TABLE OF t_address;
/


-- create the tables

CREATE TABLE customers_with_nested_table (
  id         INTEGER PRIMARY KEY,
  first_name VARCHAR2(10),
  last_name  VARCHAR2(10),
  addresses  t_nested_table_address
)
NESTED TABLE
  addresses
STORE AS
  nested_addresses;


-- insert sample data into customers_with_nested_table table

INSERT INTO customers_with_nested_table VALUES (
  1, 'Stefan', 'Brzowy',
  t_nested_table_address(
    t_address('Stanowa 2', 'Fasolowo', 'MAZ', '12345',
      t_varray_phone(
        '(22)-555-1211',
        '(22)-555-1212',
        '(22)-555-1213'
      )
    ),
    t_address('Wysoka 4', 'Skomilice', 'MA', '54321',
      t_varray_phone(
        '(12)-555-1211',
        '(12)-555-1212'
      )
    )
  )
);

-- commit the transaction
COMMIT;
