/*
BasicExample3.java pokazuje jak uywa rozszee Oracle JDBC
aby doda wiersz do tablicy customers a potem go wycign
*/
// importuj pakiety JDBC
import java.sql.*;
// importuj pakiety rozszee Oracle JDBC
import oracle.sql.*;
import oracle.jdbc.*;
public class BasicExample3 {
public static void main (String args []) {
try {
// zarejestruj sterowniki Oracle JDBC
DriverManager.registerDriver(
new oracle.jdbc.OracleDriver()
);
// DO EDYCJI - USTAWIENIA POCZENIA Z BAZ DANYCH
// utwrz obiekt Connection I podcz do bazy danych
// jako uzytkownik store z wykorzystaniem sterownika Oracle JDBC Thin
Connection myConnection = DriverManager.getConnection(
"jdbc:oracle:thin:@localhost:1521:ORCL",
"store",
"store_password"
);
// wycz tryb auto-commit
myConnection.setAutoCommit(false);
// utwrz obiekt typu oracle.sql.NUMBER
oracle.sql.NUMBER customerId = new oracle.sql.NUMBER(6);
int customerIdInt = customerId.intValue();
System.out.println("customerIdInt = " + customerIdInt);
// utwrz dwa obiekty oracle.sql.CHAR
oracle.sql.CharacterSet myCharSet =
CharacterSet.make(CharacterSet.US7ASCII_CHARSET);
oracle.sql.CHAR firstName = new oracle.sql.CHAR("Jason", myCharSet);
String firstNameString = firstName.stringValue();
System.out.println("firstNameString = " + firstNameString);
oracle.sql.CHAR lastName = new oracle.sql.CHAR("Price", myCharSet);
System.out.println("lastName = " + lastName);
// utwrz obiekt oracle.sql.DATE
oracle.sql.DATE dob = new oracle.sql.DATE("1969-02-22 13:54:12");
String dobString = dob.stringValue();
System.out.println("dobString = " + dobString);
// utwrz obiekt OraclePreparedStatement
OraclePreparedStatement myPrepStatement =
(OraclePreparedStatement) myConnection.prepareStatement(
"INSERT INTO customers " +
"(customer_id, first_name, last_name, dob, phone) VALUES (" +
"?, ?, ?, ?, ?" +
")"
);
// podcz obiekty do OraclePreparedStatement uywajc
// odpowiednich metod typu set
myPrepStatement.setNUMBER(1, customerId);
myPrepStatement.setCHAR(2, firstName);
myPrepStatement.setCHAR(3, lastName);
myPrepStatement.setDATE(4, dob);
// ustaw kolumn phone na warto NULL
myPrepStatement.setNull(5, OracleTypes.CHAR);
// uruchom PreparedStatement
myPrepStatement.execute();
System.out.println("Added row to customers table");
// otrzymaj wartoci kolumn ROWID, customer_id, first_name, last_name, dob i
// phone dla nowego wiersza uywajc obiektu OracleResultSet

Statement myStatement = myConnection.createStatement();
OracleResultSet customerResultSet =
(OracleResultSet) myStatement.executeQuery(
"SELECT ROWID, customer_id, first_name, last_name, dob, phone " +
"FROM customers " +
"WHERE customer_id = 6"
);
System.out.println("Retrieved row from customers table");
// zadeklaruj obiekt oracle.sql.ROWID do przechowywania ROWID i
// obiekt oracle.sql.CHAR do przechowywania wartoci kolumny phone
oracle.sql.ROWID rowid;
oracle.sql.CHAR phone = new oracle.sql.CHAR("", myCharSet);
// wywietl wartoci kolumn uywajc
// metod get aby odczyta wartoci
while (customerResultSet.next()) {
rowid = customerResultSet.getROWID("ROWID");
customerId = customerResultSet.getNUMBER("customer_id");
firstName = customerResultSet.getCHAR("first_name");
lastName = customerResultSet.getCHAR("last_name");
dob = customerResultSet.getDATE("dob");
phone = customerResultSet.getCHAR("phone");
System.out.println("rowid = " + rowid.stringValue());
System.out.println("customerId = " + customerId.stringValue());
System.out.println("firstName = " + firstName);
System.out.println("lastName = " + lastName);
System.out.println("dob = " + dob.stringValue());
System.out.println("phone = " + phone);
} // koniec ptli while
// zamknij obiekt OracleResultSet uywajc metody close()
customerResultSet.close();
// wycofaj zmiany dokonane w bazie danych
myConnection.rollback();
// zamknij inne obiekty JDBC
myPrepStatement.close();
myConnection.close();
} catch (SQLException e) {
System.out.println("Error code = " + e.getErrorCode());
System.out.println("Error message = " + e.getMessage());
System.out.println("SQL state = " + e.getSQLState());
e.printStackTrace();
}
} // koniec funkcji main()
}
