CREATE OR REPLACE PROCEDURE get_area
AS
  v_width SIMPLE_INTEGER := 10;
  v_height SIMPLE_INTEGER := 2;
  v_area SIMPLE_INTEGER := v_width * v_height;
BEGIN
  DBMS_OUTPUT.PUT_LINE('v_area = ' || v_area);
END get_area;
/


CREATE TABLE new_products (
product_id INTEGER CONSTRAINT new_products_pk PRIMARY KEY,
name VARCHAR2(30) NOT NULL,
price NUMBER(5, 2)
);

CREATE SEQUENCE s_product_id;

CREATE OR REPLACE PROCEDURE add_new_products
AS
  v_product_id BINARY_INTEGER;
BEGIN
  -- uywa nextval do wygenerowania pocztkowej liczby w sekwencji
  v_product_id := s_product_id.nextval;
  DBMS_OUTPUT.PUT_LINE('v_product_id = ' || v_product_id);

  -- wstawia wiersz do tabeli new_products
  INSERT INTO new_products
  VALUES (v_product_id, 'Fizyka plazmy', 49.95);

  DBMS_OUTPUT.PUT_LINE('s_product_id.currval = ' || s_product_id.currval);

  -- uywa nextval do wygenerowania kolejnej liczby w sekwencji
  v_product_id := s_product_id.nextval;
  DBMS_OUTPUT.PUT_LINE('v_product_id = ' || v_product_id);

  -- wstawia kolejny wiersz do tabeli new_products
  INSERT INTO new_products
  VALUES (v_product_id, 'Fizyka kwantowa', 69.95);

  DBMS_OUTPUT.PUT_LINE('s_product_id.currval = ' || s_product_id.currval);
END add_new_products;
/
