-- The SQL*Plus script lob_schema_10g.sql performs the following:
--   Connects as lob_user and creates items for 10g examples
--   featured in Chapter 14

CONNECT system/manager;

-- drop lob_user2
DROP USER lob_user2 CASCADE;

-- create lob_user2
CREATE USER lob_user2 IDENTIFIED BY lob_password;

-- allow the user to connect, create database objects and
-- create directory objects (for the BFILEs)
GRANT connect, resource, create any directory TO lob_user2;

-- connect as lob_user
CONNECT lob_user2/lob_password;

-- tworzenie tabel 

-- przykad niejawnej konwersji midzy obiektami CLOB i NCLOB 
CREATE TABLE nclob_content (
  id INTEGER PRIMARY KEY,
  nclob_column NCLOB
);

CREATE TABLE clob_content (
  id INTEGER PRIMARY KEY,
  clob_column CLOB
);

INSERT INTO clob_content (
  id, clob_column
) VALUES (
  1, TO_CLOB('Wije si w ciasnym kku')
);

INSERT INTO clob_content (
  id, clob_column
) VALUES (
  2, TO_CLOB(' od dnia do dnia ')
);


CREATE OR REPLACE PROCEDURE nclob_example
AS
  clob_var CLOB := 'To jest tekst CLOB';
  nclob_var NCLOB;
BEGIN
  -- wstawia clob_var do nclob_column 
  INSERT INTO nclob_content (
    id, nclob_column
  ) VALUES (
    1, clob_var
  );

  -- wybiera nclob_column do clob_var 
  SELECT nclob_column
  INTO clob_var
  FROM nclob_content
  WHERE id = 1;

  -- wywietla zawarto CLOB
  DBMS_OUTPUT.PUT_LINE('clob_var = ' || clob_var);
END nclob_example;
/

-- uycie atrybutu :new gdy obiekt LOB jest uywany w wyzwalaczu BEFORE UPDATE 
CREATE OR REPLACE TRIGGER before_clob_content_update
BEFORE UPDATE
ON clob_content
FOR EACH ROW
BEGIN
  DBMS_OUTPUT.PUT_LINE('zawarto clob_content zostaa zmieniona');
  DBMS_OUTPUT.PUT_LINE(
    'Dugo = ' || DBMS_LOB.GETLENGTH(:new.clob_column)
  );
END before_clob_content_update;
/

-- commit the transaction
COMMIT;
