CREATE OR REPLACE PROCEDURE znajdz_pracownika_wg_szefa (szef_id NUMBER)
IS
  TYPE lista IS TABLE OF VARCHAR2(30) INDEX BY BINARY_INTEGER;
  TYPE typ_kursorowy IS REF CURSOR;
  src_cur typ_kursorowy;
  uchwyt_kursora NUMBER;
  podwladni_id lista;
  podwladni_naz lista;
  ret INTEGER;
  instrukcja_sql CLOB;
BEGIN
  uchwyt_kursora := DBMS_SQL.OPEN_CURSOR;
  instrukcja_sql := 'SELECT prac_id, nazwisko FROM pracownicy WHERE szef_id = :b1';
  DBMS_SQL.PARSE(uchwyt_kursora, instrukcja_sql, DBMS_SQL.NATIVE);
  DBMS_SQL.BIND_VARIABLE(uchwyt_kursora, 'b1', szef_id);
  ret := DBMS_SQL.EXECUTE(uchwyt_kursora);
  -- Przełączenie z dbms_sql do natywnego dynamicznego SQL
  src_cur := DBMS_SQL.TO_REFCURSOR(uchwyt_kursora);
  -- Instrukcja fetch w natywnym dynamicznym SQL
  FETCH src_cur BULK COLLECT INTO podwladni_id, podwladni_naz;
  IF podwladni_id.COUNT > 0 THEN
    DBMS_OUTPUT.PUT_LINE ('ID PRACOWNIKA NAZWISKO');
    DBMS_OUTPUT.PUT_LINE ('------------- ----------------');
    FOR i IN 1 .. podwladni_id.COUNT LOOP
      DBMS_OUTPUT.PUT_LINE(podwladni_id (i) || ' ' || podwladni_naz (i));
    END LOOP;
  END IF;
  CLOSE src_cur;
END znajdz_pracownika_wg_szefa;
/

