/*
 * LobInsert.sql
 * Rozdzia 16, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje wstawianie danych do typw LOB
 */

exec CLEAN_SCHEMA.TABLES
exec CLEAN_SCHEMA.OBJECTS
exec CLEAN_SCHEMA.PROCS

CREATE TABLE book_samples (
   book_sample_id   NUMBER (10) PRIMARY KEY,
   isbn             CHAR(10 CHAR),
   description      CLOB,
   nls_description  NCLOB,
   book_cover       BLOB,
   chapter_title    VARCHAR2(30 CHAR),
   chapter          BFILE
)  
   LOB (book_cover) 
      STORE AS blob_seg ( TABLESPACE blob_ts
                 CHUNK 8192
                 PCTVERSION 0
                 NOCACHE
                 NOLOGGING
                 DISABLE STORAGE IN ROW)
   LOB (description, nls_description) 
   STORE AS ( TABLESPACE clob_ts
                 CHUNK 8192
                 PCTVERSION 10
                 NOCACHE
                 LOGGING
                 ENABLE STORAGE IN ROW);

INSERT INTO book_samples (
   book_sample_id,
   isbn,
   description,
   nls_description,
   book_cover,
   chapter)
 VALUES (
   1,
   '72230665', 
   'To podstawowe zrodo wiedzy o PL/SQL zostalo poprawione i rozszerzone. Zawiera calkiem nowe przyklady bazujace na nowej wersji Oracle Database 10g. Ponadto caly kod przedstawiony w ksiazce oraz dodatkowe zagadnienia s dostepne na witrynie internetowej.',
   EMPTY_CLOB(),
   EMPTY_BLOB(),
   BFILENAME('BOOK_SAMPLES_LOC', '72230665.jpg'));

commit;

PROMPT
PROMPT ** Rozmiar kolumny nls_description po wywolaniu EMPTY_CLOB()
PROMPT

SELECT LENGTH(nls_description)
  FROM book_samples;

PROMPT
PROMPT ** Rozmiar kolumny description po wstawieniu wartosci
PROMPT

SELECT LENGTH(description)
  FROM book_samples;

PROMPT
PROMPT ** Sprawdzanie, czy kolumna description zawiera wartosci null
PROMPT

SELECT COUNT(rowid)
  FROM book_samples
  WHERE nls_description IS NULL;

PROMPT
PROMPT ** Pobranie danych z kolumny description pokazuje, ze dane zostaly wstawione
PROMPT

SET LONG 64000
SELECT description
  FROM book_samples;

