/*
 * CreateLOBTables.sql
 * Rozdzia 16, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje opcje przechowywania dostpne w typach LOB
 */

EXEC CLEAN_SCHEMA.tables

PROMPT 
PROMPT  Tworzenie tabel
PROMPT

-- W tabeli book_samples klauzula pierwszego typu obejmuje
--  segment nazwany, podczas gdy klauzula drugiego typu LOB ju nie.
--  Prba dodania nazwy spowodowaaby bd, poniewa lista kolumn
--  zawiera wicej ni jedn kolumn.  W takiej sytuacji
--  to system okrela nazw segmentu

CREATE TABLE book_samples (
   book_sample_id   NUMBER (10) PRIMARY KEY,
   isbn             CHAR(10 CHAR),
   description      CLOB,
   nls_description  NCLOB,
   book_cover       BLOB,
   chapter_title    VARCHAR2(30 CHAR),
   chapter          BFILE
)  
   LOB (book_cover) 
      STORE AS blob_seg ( TABLESPACE blob_ts
                 CHUNK 8192
                 PCTVERSION 0
                 NOCACHE
                 NOLOGGING
                 DISABLE STORAGE IN ROW)
   LOB (description, nls_description) 
   STORE AS ( TABLESPACE clob_ts
                 CHUNK 8192
                 PCTVERSION 10
                 NOCACHE
                 LOGGING
                 ENABLE STORAGE IN ROW);



INSERT INTO book_samples (
   book_sample_id,
   isbn,
   description,
   nls_description,
   book_cover,
   chapter)
 VALUES (
   1,
   '72230665', 
   'To podstawowe zrodo wiedzy o PL/SQL zostalo poprawione i rozszerzone. Zawiera calkiem nowe przyklady bazujace na nowej wersji Oracle Database 10g. Ponadto caly kod przedstawiony w ksiazce oraz dodatkowe zagadnienia s dostepne na witrynie internetowej.',
   'The essential reference for PL/SQL has been revised and expanded, featuring all new examples throughout based on the new Oracle Database 10g, plus all the books code and expanded topics are included on the website for download.',
   empty_blob(),
   bfilename('image_dir', '72230665.jpg'));

commit;
