/*
 * Inheritance.sql
 * Rozdzia 14, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje dziedziczenie typw obiektowych
 */

exec clean_schema.synonyms
exec clean_schema.tables
exec clean_schema.objects

-- discount_price_obj to typ danych atrybutu price
--   w typie obiektowym inventory_obj

-- Specyfikacja discount_price_obj

CREATE OR REPLACE TYPE discount_price_obj AS OBJECT (
   discount_rate   NUMBER (10, 4),
   price           NUMBER (10, 2),
   CONSTRUCTOR FUNCTION discount_price_obj (price NUMBER)
      RETURN SELF AS RESULT
)
INSTANTIABLE FINAL;
/

-- Ciao

CREATE OR REPLACE TYPE BODY discount_price_obj
AS
   CONSTRUCTOR FUNCTION discount_price_obj (price NUMBER)
      RETURN SELF AS RESULT
   AS
   BEGIN
      SELF.price := price * .9;
      RETURN;
   END discount_price_obj;
END;
/

-- inventory_obj to zoony typ obiektowy, ktry uywa
--   typu discount_price_obj jako typu danych
--   atrybutu price.  Jest on bazowym typem obiektowym,
--   ktry umoliwia tworzenie obiektw

-- Specyfikacja inventory_obj

CREATE OR REPLACE TYPE inventory_obj AS OBJECT (
   item_id          NUMBER (10),
   num_in_stock     NUMBER (10),
   reorder_status   VARCHAR2 (20 CHAR),
   price            NUMBER(10,2),
   CONSTRUCTOR FUNCTION inventory_obj (
      item_id        IN   NUMBER,
      num_in_stock   IN   NUMBER,
      price          IN   NUMBER
   )
      RETURN SELF AS RESULT,
   MEMBER PROCEDURE print_inventory,
   MEMBER PROCEDURE print_status,
   MEMBER PROCEDURE print_price
)
INSTANTIABLE NOT FINAL;
/

CREATE OR REPLACE TYPE BODY inventory_obj
AS
   CONSTRUCTOR FUNCTION inventory_obj (
      item_id        IN   NUMBER,
      num_in_stock   IN   NUMBER,
      price          IN   NUMBER
   )
      RETURN SELF AS RESULT
   IS
   BEGIN
      SELF.item_id := item_id;
      SELF.num_in_stock := num_in_stock;
      SELF.price := price;
      RETURN;
   END;
   MEMBER PROCEDURE print_inventory
   IS
   BEGIN
      DBMS_OUTPUT.put_line ('ASORTYMENT KSIEGARNI1');
      DBMS_OUTPUT.put_line ('=====================');
      DBMS_OUTPUT.put_line (   'Liczba artykulow o numerze '
                            || SELF.item_id
                            || ' to '
                            || SELF.num_in_stock
                            || ' .');
   END print_inventory;
   MEMBER PROCEDURE print_status
   IS
      v_status   VARCHAR2 (20);
   BEGIN
      IF SELF.num_in_stock > 0
      THEN
         v_status := 'DOSTEPNY';
      ELSE
         v_status := 'NIEDOSTEPNY';
      END IF;

      DBMS_OUTPUT.put_line ('STAN MAGAZYNU KSIEGARNI1');
      DBMS_OUTPUT.put_line ('========================');
      DBMS_OUTPUT.put_line ('Produkt o numerze ' || SELF.item_id || ' jest '
                            || v_status
                           );
   END print_status;
   MEMBER PROCEDURE print_price
   IS
      v_discount_price   discount_price_obj
                                           := discount_price_obj (SELF.price);
   BEGIN
      DBMS_OUTPUT.put_line ('CENY W KSIEGARNI1');
      DBMS_OUTPUT.put_line ('=================');
      DBMS_OUTPUT.put_line ('Produkt o numerze ' || SELF.item_id);
      DBMS_OUTPUT.put_line ('Cena detaliczna: ' || SELF.price || ' zlotych');
      DBMS_OUTPUT.put_line (   'NASZA BARDZO - BARDZO - NISKA CENA: '
                            || v_discount_price.price
                            || ' zlotych'
                           );
   END print_price;
END;
/

-- Uyj tego kodu do przetestowania obiektu inventory_obj
/******************************************
*
* SET SERVEROUTPUT ON SIZE 1000000
* DECLARE
*    v_inventory   inventory_obj := inventory_obj (3124, 15, 39.99);
* BEGIN
*    v_inventory.print_inventory;
*    DBMS_OUTPUT.put_line ('	');
*    v_inventory.print_status;
*    DBMS_OUTPUT.put_line ('	');
*    v_inventory.print_price;
* END;
* /
* 
*******************************************/


CREATE OR REPLACE TYPE book_obj
UNDER inventory_obj (
   isbn        CHAR (10 CHAR),
   CATEGORY    VARCHAR2 (20 CHAR),
   title       VARCHAR2 (100 CHAR),
   num_pages   NUMBER,
   CONSTRUCTOR FUNCTION book_obj (
      item_id        NUMBER,
      num_in_stock   NUMBER,
      price          NUMBER,
      isbn           CHAR,
      title          VARCHAR2,
      num_pages      NUMBER
   )
      RETURN SELF AS RESULT,
   MEMBER PROCEDURE print_book_information,
   OVERRIDING MEMBER PROCEDURE print_price
)
INSTANTIABLE FINAL;
/

CREATE OR REPLACE TYPE BODY book_obj
IS
   CONSTRUCTOR FUNCTION book_obj (
      item_id        NUMBER,
      num_in_stock   NUMBER,
      price          NUMBER,
      isbn           CHAR,
      title          VARCHAR2,
      num_pages      NUMBER
   )
      RETURN SELF AS RESULT
   IS
   BEGIN
      SELF.item_id := item_id;
      SELF.num_in_stock := num_in_stock;
      SELF.price := price;
      SELF.isbn := isbn;
      SELF.title := title;
      SELF.num_pages := num_pages;
      RETURN;
   END book_obj;
   MEMBER PROCEDURE print_book_information
   IS
   BEGIN
      DBMS_OUTPUT.put_line ('INFORMACJE O KSIAZCE');
      DBMS_OUTPUT.put_line ('====================');
      DBMS_OUTPUT.put_line ('Tytul: '
                            || SELF.title);
      DBMS_OUTPUT.put_line ('Liczba stron: ' 
                            || SELF.num_pages);
      DBMS_OUTPUT.put_line ('Na stanie: ' 
                            || SELF.num_in_stock);
   END print_book_information;
   OVERRIDING MEMBER PROCEDURE print_price
   IS
   BEGIN
      DBMS_OUTPUT.put_line ('CENY W KSIEGARNI1');
      DBMS_OUTPUT.put_line ('================');
      DBMS_OUTPUT.put_line ('Tytul: '
                            || SELF.title);
      DBMS_OUTPUT.put_line ('Zawsze niska cena: ' 
                            || SELF.price);
   END print_price;
END;
/

-- Uyj tego kodu do przetestowania typu book_obj
/******************************************
*
* SET SERVEROUTPUT ON SIZE 1000000
* DECLARE
*    v_book book_obj := book_obj (3124, 15, 39.99, '72121203', 'Oracle DBA 101', 563);
* BEGIN
*    v_book.print_book_information;
*    DBMS_OUTPUT.put_line ('	');
*    v_book.print_price;
* END;
* /
*
*******************************************/
