/*
 * dbms_sql_02.sql
 * Rozdzia 13, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Cel:
 *   Suy do testowania NDS
 */

SET PAGESIZE 99
SET SERVEROUTPUT ON SIZE 1000000

-- Przygotowanie zmiennej wizanej do przekazywania nazwy tabeli
VARIABLE table_name   VARCHAR2(30)
VARIABLE column_name1 VARCHAR2(30)
VARIABLE column_name2 VARCHAR2(30)
VARIABLE column_name3 VARCHAR2(30)

-- Blok testowy tworzcy, zwikszajcy i usuwajcy tabel
DECLARE

  -- Zmienne lokalne
  table_name_in          VARCHAR2(30) := 'TEST_MESSAGES';
  table_definition_in    VARCHAR2(2000);
  column_name1           VARCHAR2(30) := 'TEST_MESSAGE_ID';
  column_name2           VARCHAR2(30) := 'MESSAGE_SENT';
  column_name3           VARCHAR2(30) := 'REVIEWED_BY';
  table_column_value1    NUMBER       := '1';
  table_column_value2    VARCHAR2(20) := 'Witaj, swiecie';
  table_column_value3    VARCHAR2(30) := USER;

BEGIN

  -- Przypisanie nazwy tabeli do zmiennej powizanej
  :table_name := table_name_in;
  :column_name1 := column_name1;
  :column_name2 := column_name2;
  :column_name3 := column_name3;

  -- Inicjowanie tabeli
  table_definition_in := '( test_message_id NUMBER'      ||CHR(10)
                      || ', message_sent    VARCHAR2(20)'||CHR(10)
                      || ', reviewed_by     VARCHAR2(30))';

  -- Wiersz rozdzielajcy
  dbms_output.put_line(nds_tutorial.dline);

  -- Tworzenie tabeli
  nds_tutorial.create_table(table_name_in,table_definition_in);

  -- Wiersz rozdzielajcy
  dbms_output.put_line(nds_tutorial.dline);

  -- Wstawianie danych do tabeli
  nds_tutorial.insert_into_table( table_name_in
                                , table_column_value1
                                , table_column_value2
                                , table_column_value3);

  -- Wiersz rozdzielajcy
  dbms_output.put_line(nds_tutorial.dline);

END;
/

-- Konfiguracja rodowiska SQL*PLUS na potrzeby skryptu
COL c1   FORMAT 999      HEADING "Test|Komunikat|ID #"
COL c2   FORMAT A20      HEADING "Wyslany komunikat"
COL c3   FORMAT A30      HEADING "Odbiorca"

-- Select from the dynamically created table.
SELECT   test_message_id c1
,        message_sent c2
,        reviewed_by c3
FROM     test_messages;

-- Uycie DBMS_SQL_TUTORIAL do usunicia tabeli
BEGIN

  -- Wiersz rozdzielajcy
  dbms_output.put_line(nds_tutorial.dline);

  -- Uruchomienie dynamicznego polecenia DQL na tabeli
  nds_tutorial.single_row_return(:table_name
                                ,:column_name1
                                ,:column_name2
                                ,:column_name3);

  -- Wiersz rozdzielajcy
  dbms_output.put_line(nds_tutorial.dline);

  -- Wiersz rozdzielajcy
  dbms_output.put_line(nds_tutorial.dline);

  -- Usunicie tabeli
  nds_tutorial.drop_table(:table_name);

  -- Wiersz rozdzielajcy
  dbms_output.put_line(nds_tutorial.dline);

END;
/
