/*
 * logInventoryChanges1.sql
 * Rozdzia 10, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt tworzy tabel INVENTORY_AUDIT i wyzwalacz z predykatami
 */

SET ECHO ON

BEGIN
  FOR i IN (SELECT   null
            FROM     user_tables
            WHERE    table_name = 'INVENTORY_AUDIT') LOOP
    EXECUTE IMMEDIATE 'DROP TABLE inventory_audit';
  END LOOP;
END;
/

CREATE TABLE inventory_audit (
  change_type     CHAR(1) NOT NULL,
  changed_by      VARCHAR2(8) NOT NULL,
  timestamp       DATE NOT NULL,
  old_isbn        CHAR(10),
  new_isbn        CHAR(10),
  old_status      VARCHAR2(25),
  new_status      VARCHAR2(25),
  old_status_date DATE,
  new_status_date DATE,
  old_amount      NUMBER,
  new_amount      NUMBER
);

CREATE OR REPLACE TRIGGER LogInventoryChanges
  BEFORE INSERT OR DELETE OR UPDATE ON inventory
  FOR EACH ROW
DECLARE
  v_ChangeType CHAR(1);
BEGIN
  /* 'I' odpowiada instrukcji INSERT, 'D' instrukcji DELETE, a 'U' - UPDATE */
  IF INSERTING THEN
    v_ChangeType := 'I';
  ELSIF UPDATING THEN
    v_ChangeType := 'U';
  ELSE
    v_ChangeType := 'D';
  END IF;

  /* Rejestruje wszystkie zmiany zawartoci tabeli 
     inventory_audit. Funkcja SYSDATE suy do wygenerowania znacznika czasu, a
     funkcja USER zwraca identyfikator userid biecego uytkownika */
  INSERT INTO inventory_audit
    (change_type, changed_by, timestamp,
     old_isbn, old_status, old_status_date, old_amount,
     new_isbn, new_status, new_status_date, new_amount)
  VALUES
    (v_ChangeType, USER, SYSDATE,
     :old.isbn, :old.status, :old.status_date, :old.amount,
     :new.isbn, :new.status, :new.status_date, :new.amount);
END LogInventoryChanges;
/
show errors
