/*
 * limitMajors.sql
 * Rozdzia 10, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje niemutujcy wyzwalacz zdefiniowany przez uytkownika
 */

SET ECHO ON

CREATE OR REPLACE TRIGGER LimitMajors
  /* Ogranicza liczb studentw na kadej specjalizacji do piciu.
     Jeli ten limit zostanie przekroczony, zgasza bd za pomoc funkcji
     raise_application_error */
  BEFORE INSERT OR UPDATE OF major ON students
  FOR EACH ROW
DECLARE
  v_MaxStudents CONSTANT NUMBER := 5;
  v_CurrentStudents NUMBER;
BEGIN
  -- Okrela biec liczb studentw na danej
  -- specjalizacji
  SELECT COUNT(*)
    INTO v_CurrentStudents
    FROM students
    WHERE major = :new.major;

  -- Jeli nie ma miejsca, zgasza bd
  IF v_CurrentStudents + 1 > v_MaxStudents THEN
    RAISE_APPLICATION_ERROR(-20000, 
      'Zbyt wielu studentow na specjalizacji ' || :new.major);

  END IF;
END LimitMajors;
/

UPDATE students
SET major = 'Historia'
WHERE id = 1;
