/*
 * UpdateCategoryStats.sql
 * Rozdzia 10, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje wyzwalacze zdefiniowane przez uytkownika
 */
REM UpdateCategoryStats.sql
REM Przyklad wyzwalacza DML

CREATE OR REPLACE TRIGGER UpdateCategoryStats
  /* Zapewnia synchronizacj tabeli category_stats ze 
     zmianami wprowadzonymi w tabeli books */
  AFTER INSERT OR DELETE OR UPDATE ON books
DECLARE
  CURSOR c_Statistics IS
    SELECT category,
           COUNT(*) total_books,
           AVG(price) average_price
      FROM books
      GROUP BY category;
BEGIN
  /* Najpierw usuwa dane z tabeli category_stats. Powoduje to wyzerowanie
     statystyk i jest niezbdne, aby mona obsuy sytuacj usunicia
     wszystkich ksiek z danej kategorii */
  DELETE FROM category_stats;

  /* Przejcie w ptli po kadej kategorii i wstawienie odpowiedniego wiersza 
     do tabeli category_stats */
  FOR v_StatsRecord in c_Statistics LOOP
    INSERT INTO category_stats (category, total_books, average_price)
      VALUES (v_StatsRecord.category, v_StatsRecord.total_books,
              v_StatsRecord.average_price);
  END LOOP;
END UpdateCategoryStats;
/
show errors
