/*
 * LogPkg1.sql
 * Rozdzia 10, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje wywoywanie w wyzwalaczach
 * pakietw zdefiniowanych przez uytkownika
 */

CREATE OR REPLACE PACKAGE LogPkg AS
  PROCEDURE LogConnect(p_UserID IN VARCHAR2);
  PROCEDURE LogDisconnect(p_UserID IN VARCHAR2);
END LogPkg;
/
show errors

CREATE OR REPLACE PACKAGE BODY LogPkg AS
  PROCEDURE LogConnect(p_UserID IN VARCHAR2) IS
  BEGIN
    INSERT INTO connect_audit (user_name, operation, timestamp)
      VALUES (p_USerID, 'CONNECT', SYSDATE);
  END LogConnect;

  PROCEDURE LogDisconnect(p_UserID IN VARCHAR2) IS
  BEGIN
    INSERT INTO connect_audit (user_name, operation, timestamp)
      VALUES (p_USerID, 'DISCONNECT', SYSDATE);
  END LogDisconnect;
END LogPkg;
/
show errors
