/*
 * GenerateStudentID.sql
 * Rozdzia 10, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje wyzwalacze zdefiniowane przez uytkownika
 */

SET ECHO ON

CREATE OR REPLACE TRIGGER GenerateAuthorID
  BEFORE INSERT OR UPDATE ON authors
  REFERENCING new AS new_author
  FOR EACH ROW
BEGIN
  /* Zapenia pole ID tabeli authors nastpn wartoci sekwencji
     author_sequence. Poniewa ID to kolumna w tabeli authors, :new.ID
     jest prawidowym odwoaniem */
  SELECT author_sequence.NEXTVAL
    INTO :new_author.ID
    FROM dual;
END GenerateAuthorID;
/
