/*
 * dependencies.sql
 * Rozdzia 9, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje dziaanie obiektw zalenych
 */

COLUMN object_name FORMAT a20

-- Prosta tabela
CREATE TABLE simple_table (f1 NUMBER);

-- Procedura pakietu uywajca powyszej tabeli
CREATE OR REPLACE PACKAGE Dependee AS
  PROCEDURE Example(p_Val IN NUMBER);
END Dependee;
/

CREATE OR REPLACE PACKAGE BODY Dependee AS
  PROCEDURE Example(p_Val IN NUMBER) IS
  BEGIN
     INSERT INTO simple_table VALUES (p_Val);
  END Example;
END Dependee;
/

-- Procedura uywajca pakietu Dependee
CREATE OR REPLACE PROCEDURE Depender(p_Val IN NUMBER) AS
BEGIN
  Dependee.Example(p_Val + 1);
END Depender;
/

-- Zapytanie do tabeli user_objects pozwala sprawdzi, czy wszystkie obiekty s prawidowe
SELECT object_name, object_type, status
  FROM user_objects
  WHERE object_name IN ('DEPENDER', 'DEPENDEE',
                        'SIMPLE_TABLE');

-- Zmiana jedynie ciaa tabeli. Warto zauway, e
-- nagwek nie zmienia si
CREATE OR REPLACE PACKAGE BODY Dependee AS
  PROCEDURE Example(p_Val IN NUMBER) IS
  BEGIN
    INSERT INTO simple_table VALUES (p_Val - 1);
  END Example;
END Dependee;
/

-- Teraz tabela user_objects pokazuje, e obiekt Depender wci jest prawidowy
SELECT object_name, object_type, status
  FROM user_objects
  WHERE object_name IN ('DEPENDER', 'DEPENDEE',
                        'SIMPLE_TABLE');

-- Nawet usunicie uywanej tabeli spowoduje, e nieprawidowe
-- bdzie jedynie ciao pakietu
DROP TABLE simple_table;

SELECT object_name, object_type, status
  FROM user_objects
  WHERE object_name IN ('DEPENDER', 'DEPENDEE',
                        'SIMPLE_TABLE');
