/*
 * callPP.sql
 * Rozdzia 9, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje wywoania do trwaego pakietu
 */

set serveroutput on

DECLARE
  v_BookTable PersistPkg.t_BookTable;
  v_NumRows NUMBER := PersistPkg.v_MaxRows;
  v_Title books.title%TYPE;
BEGIN
  PersistPkg.ReadBooks(v_BookTable, v_NumRows);
  DBMS_OUTPUT.PUT_LINE(' Pobrane wiersze (' || v_NumRows || '):');
  FOR v_Count IN 1..v_NumRows LOOP
    SELECT title
      INTO v_Title
      FROM books
      WHERE isbn = v_BookTable(v_Count);
    DBMS_OUTPUT.PUT_LINE(v_Title);
  END LOOP;
END;
/
