/*
 * OracleErrors.sql
 * Rozdzia 9, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje zastosowanie potokowej funkcji tabelowej
 */

DROP TYPE OracleErrors;

CREATE OR REPLACE TYPE OracleError AS OBJECT (
  ErrNumber INTEGER,
  Message VARCHAR2(4000));
/

CREATE OR REPLACE TYPE OracleErrors AS TABLE OF OracleError;
/

-- Teraz mona utworzy potrzebn funkcj. Warto zauway, e mona zastosowa
-- sowo kluczowe DETERMINISITIC, poniewa funkcja zawsze zwraca te same dane
-- dla takich samych danych wejciowych. (Nie przyjmuje adnych danych wejciowych,
-- dlatego jest to w oczywisty sposb prawdziwe.)
CREATE OR REPLACE FUNCTION OracleErrorTable
  RETURN OracleErrors DETERMINISTIC PIPELINED
AS
  v_Low PLS_INTEGER := -65535;
  v_High PLS_INTEGER := 100;
  v_Message VARCHAR2(4000);
BEGIN
  FOR i IN v_Low..v_High LOOP
    -- Pobieranie komunikatu dla bdu o danym numerze
    v_Message := SQLERRM(i);
    
    -- Jeli jest to dozwolone, wywietlanie komunikatu
    IF v_Message != ' -' || TO_CHAR(i) || ': wyjatek spoza ORACLE '
    AND v_Message != 'ORA' || TO_CHAR(i, '00000') || ': Komunikatu ' ||
        TO_CHAR(-i) || ' nie znaleziono;  product=RDBMS; facility=ORA'
    THEN
      PIPE ROW(OracleError(i, v_Message));
    END IF;
  END LOOP;
  RETURN;
END;
/

CREATE OR REPLACE VIEW all_oracle_errors
  AS SELECT * FROM TABLE(OracleErrorTable());

desc all_oracle_errors
SELECT MIN(errnumber), MAX(errnumber), COUNT(*)
  FROM all_oracle_errors;


COLUMN message FORMAT a60

SELECT *
  FROM all_oracle_errors
  WHERE errnumber BETWEEN -115 AND 100;
  
