/*
 * calls.sql
 * Rozdzia 8, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje zastosowanie instrukcji CALL
 */

CREATE OR REPLACE PROCEDURE CallProc1(p1 IN VARCHAR2 := NULL) AS
BEGIN
  DBMS_OUTPUT.PUT_LINE('CallProc1 wywolana z parametrem ' || p1);
END CallProc1;
/

CREATE OR REPLACE PROCEDURE CallProc2(p1 IN OUT VARCHAR2) AS
BEGIN
  DBMS_OUTPUT.PUT_LINE('CallProc2 wywolana z parametrem ' || p1);
  p1 := p1 || ' zwrocenie!';
END CallProc2;
/

CREATE OR REPLACE FUNCTION CallFunc(p1 IN VARCHAR2)
  RETURN VARCHAR2 AS
BEGIN
  DBMS_OUTPUT.PUT_LINE('CallFunc wywolana z parametrem  ' || p1);
  RETURN p1;
END CallFunc;
/

set serveroutput on

-- Poprawne wywoania bezporednio z kodu SQL
CALL CallProc1('Witaj!');
CALL CallProc1();
VARIABLE v_Output VARCHAR2(50);
CALL CallFunc('Witaj!') INTO :v_Output;
PRINT v_Output
CALL CallProc2(:v_Output);
PRINT v_Output

-- To wywoanie jest niedozwolone
BEGIN
  CALL CallProc1();
END;
/

-- Natomiast te wywoania s poprawne
DECLARE
  v_Result VARCHAR2(50);
BEGIN
  EXECUTE IMMEDIATE 'CALL CallProc1(''Pozdrowienia od PL/SQL'')';
  EXECUTE IMMEDIATE
    'CALL CallFunc(''Pozdrowienia od PL/SQL'') INTO :v_Result'
  USING OUT v_Result;
END;
/

